/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.renderer.CRExternPrototypeDecl;
import org.web3d.vrml.renderer.DefaultLocator;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;

public abstract class CRExternProtoBuilder
implements ContentHandler,
ProtoHandler,
ScriptHandler,
RouteHandler {
    private static final int STACK_START_SIZE = 50;
    private static final int STACK_INCREMENT = 25;
    private boolean init;
    private ErrorHandler errorHandler;
    private Locator locator;
    private boolean inExternProtoDecl = false;
    private boolean inExternProtoURI = false;
    private boolean newFieldDecl = false;
    private int currentFieldIndex;
    private AbstractProto currentProto;
    private AbstractProto rootProto;
    private int[] childIndexStack;
    private int topOfStack;
    private Map globalDefMap;
    private Map globalProtoMap;
    private Map globalExternProtoMap;
    private HashMap defMap;
    private HashMap protoMap;
    private HashMap externProtoMap;
    private SimpleStack protoDeclStack;
    private SimpleStack scriptStack;
    private SimpleStack defMapStack;
    private SimpleStack protoMapStack;
    private boolean isVrml97;
    private HashSet ignoreDefSet;
    private String worldURL;
    private VRMLNodeFactory nodeFactory;
    private FrameStateManager stateManager;

    protected CRExternProtoBuilder(VRMLNodeFactory vRMLNodeFactory) throws NullPointerException {
        this.nodeFactory = vRMLNodeFactory;
        this.defMap = new HashMap();
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.protoDeclStack = new SimpleStack();
        this.scriptStack = new SimpleStack();
        this.defMapStack = new SimpleStack();
        this.protoMapStack = new SimpleStack();
        this.childIndexStack = new int[50];
    }

    public AbstractProto getPrototype() {
        return this.rootProto;
    }

    public void reset() {
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        this.newFieldDecl = false;
        this.worldURL = null;
        this.defMap.clear();
        this.protoMap.clear();
        this.externProtoMap.clear();
        this.protoDeclStack.clear();
        this.defMapStack.clear();
        this.protoMapStack.clear();
    }

    public void setGlobals(Map map, Map map2, Map map3) {
        this.globalDefMap = map == null ? new HashMap() : map;
        this.globalProtoMap = map2 == null ? new HashMap() : map2;
        this.globalExternProtoMap = map3 == null ? new HashMap() : map3;
        this.init = true;
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.isVrml97 = bl;
    }

    public void newProto() {
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5) throws SAVException, VRMLException {
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.worldURL = string;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        if (this.locator == null) {
            this.locator = new DefaultLocator();
        }
        if (!this.init) {
            this.globalDefMap = new HashMap();
            this.globalProtoMap = new HashMap();
            this.globalExternProtoMap = new HashMap();
            this.init = true;
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        throw new SAVException("Externprotos cannot contain PROFILE statements");
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        throw new SAVException("Externprotos cannot contain COMPONENT statements");
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
    }

    public void endDocument() throws SAVException, VRMLException {
        this.topOfStack = 0;
        this.currentProto = null;
        this.currentFieldIndex = -1;
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        throw new SAVException("Externprotos cannot contain IMPORT statements");
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        throw new SAVException("Externprotos cannot contain EXPORT statements");
    }

    public void endNode() throws SAVException, VRMLException {
    }

    public void startField(String string) throws SAVException, VRMLException {
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
    }

    public void useDecl(String string) throws SAVException, VRMLException {
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
    }

    public void endProtoDecl() throws SAVException, VRMLException {
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        int n2;
        if (!this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "proto field declaration not in proto!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentFieldIndex = n2 = this.currentProto.appendField(vRMLFieldDeclaration);
        this.newFieldDecl = true;
        if (object != null && this.currentProto instanceof VRMLProtoDeclare) {
            VRMLProtoDeclare vRMLProtoDeclare = (VRMLProtoDeclare)this.currentProto;
            if (object instanceof String) {
                vRMLProtoDeclare.setRawValue(n2, (String)object);
            } else {
                vRMLProtoDeclare.setRawValue(n2, (String[])object);
            }
        }
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
    }

    public void startProtoBody() throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Starting proto body while still in declaration");
        }
    }

    public void endProtoBody() throws SAVException, VRMLException {
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Nested PROTO declarations not allowed");
        }
        CRExternPrototypeDecl cRExternPrototypeDecl = this.createDecl(string, this.nodeFactory, this.isVrml97);
        cRExternPrototypeDecl.setFrameStateManager(this.stateManager);
        this.externProtoMap.put(string, cRExternPrototypeDecl);
        this.currentProto = cRExternPrototypeDecl;
        this.rootProto = cRExternPrototypeDecl;
        this.topOfStack = 0;
        this.inExternProtoDecl = true;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.inExternProtoDecl = false;
        this.inExternProtoURI = true;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        if (!this.inExternProtoURI) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "EXTERNPROTO URI declaration not allowed here");
        }
        ((ExternalPrototypeDecl)this.currentProto).setUrl(stringArray);
        ((ExternalPrototypeDecl)this.currentProto).setWorldUrl(this.worldURL);
        this.currentProto = null;
    }

    public void startScriptDecl() throws SAVException, VRMLException {
    }

    public void endScriptDecl() throws SAVException, VRMLException {
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
    }

    public abstract CRExternPrototypeDecl createDecl(String var1, VRMLNodeFactory var2, boolean var3);
}

