/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.ietf.uri.URIUtils;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLPrototype;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRProtoCreator;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.EPDInstanceEntry;
import org.web3d.vrml.util.URLChecker;

public abstract class CRExternPrototypeDecl
extends ExternalPrototypeDecl {
    protected VRMLPrototype proto;
    protected boolean isVrml97;
    protected boolean inSetup;
    protected String[] vfUrl;
    protected String worldURL;
    protected int loadState;
    protected VRMLNodeFactory nodeFactory;
    protected ArrayList instanceList;
    protected ArrayList wrInstances;
    protected String uriRef;
    protected FrameStateManager stateManager;

    public CRExternPrototypeDecl(String string, VRMLNodeFactory vRMLNodeFactory, boolean bl) {
        super(string, bl);
        this.proto = this.proto;
        this.isVrml97 = false;
        this.inSetup = true;
        this.uriRef = null;
        this.nodeFactory = vRMLNodeFactory;
        this.instanceList = new ArrayList();
        this.wrInstances = new ArrayList();
    }

    public void addInstance(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        this.instanceList.add(new EPDInstanceEntry(vRMLNodeType, n, vRMLNodeType2));
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public VRMLPrototype getProtoDefinition() {
        return this.proto;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        this.loadState = n;
    }

    public void setWorldUrl(String string) {
        if (string == null) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            this.vfUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfUrl, (boolean)false);
        }
    }

    public boolean checkValidContentType(String string) {
        return true;
    }

    public void setLoadedURI(String string) {
        String[] stringArray = URIUtils.stripFile((String)string);
        this.uriRef = stringArray[2];
    }

    public List getInstances() {
        WeakReference[] weakReferenceArray = new WeakReference[this.wrInstances.size()];
        this.wrInstances.toArray(weakReferenceArray);
        ArrayList<VRMLProtoInstance> arrayList = new ArrayList<VRMLProtoInstance>();
        int n = 0;
        while (n < weakReferenceArray.length) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)weakReferenceArray[n].get();
            if (vRMLProtoInstance != null) {
                arrayList.add(vRMLProtoInstance);
            }
            ++n;
        }
        return arrayList;
    }

    public void setUrl(String[] stringArray) {
        if (!this.inSetup) {
            throw new RuntimeException("ExternProto's cannot change  URL at runtime");
        }
        this.vfUrl = stringArray;
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    protected void finishSetContent(PrototypeDecl prototypeDecl, CRProtoCreator cRProtoCreator) {
        EPDInstanceEntry[] ePDInstanceEntryArray = new EPDInstanceEntry[this.instanceList.size()];
        this.instanceList.toArray(ePDInstanceEntryArray);
        int n = 0;
        while (n < ePDInstanceEntryArray.length) {
            VRMLNodeType vRMLNodeType = ePDInstanceEntryArray[n].instance;
            VRMLNodeType vRMLNodeType2 = ePDInstanceEntryArray[n].parent;
            cRProtoCreator.fillinInstance(prototypeDecl, (CRProtoInstance)vRMLNodeType);
            vRMLNodeType.setupFinished();
            vRMLNodeType2.notifyExternProtoLoaded(ePDInstanceEntryArray[n].idx, vRMLNodeType);
            this.wrInstances.add(new WeakReference<VRMLNodeType>(vRMLNodeType));
            ++n;
        }
        this.instanceList.clear();
    }
}

