/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.CRROUTE;
import org.web3d.vrml.renderer.CRVRMLScene;
import org.web3d.vrml.renderer.DefaultLocator;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;

public abstract class CRMainSceneBuilder
implements ContentHandler,
ProtoHandler,
ScriptHandler,
RouteHandler {
    protected static final String BAD_METHOD_MSG = "This method was called when it should not be. Not used by this impl";
    protected static final int STACK_START_SIZE = 100;
    protected static final int STACK_INCREMENT = 25;
    protected static final String VRML97_PROFILE_STRING = "vrml97";
    protected boolean init;
    protected ErrorHandler errorHandler;
    protected Locator locator;
    protected boolean inScript = false;
    protected int ignoreNodeCounter;
    protected boolean inStatic = false;
    protected int staticDepthCounter;
    protected boolean badFieldName;
    protected int currentFieldIndex;
    protected VRMLNodeType currentNode;
    protected VRMLScriptNodeType currentScript;
    protected CRVRMLScene scene;
    protected SceneMetaData metaData;
    protected VRMLNodeType root;
    protected VRMLNodeType[] nodeStack;
    protected int[] childIndexStack;
    protected int topOfStack;
    protected Map defMap;
    protected Map protoMap;
    protected Map externProtoMap;
    protected SimpleStack scriptStack;
    protected VRMLNodeFactory nodeFactory;
    protected boolean isVrml97;
    protected HashSet dontLoadTypes;
    protected HashSet ignoreDefSet;
    protected HashSet staticNodeSet;
    protected String worldURL;
    protected String version;
    protected FrameStateManager stateManager;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLBackgroundNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLFogNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLLightNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLAudioClipNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLViewpointNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLInlineNodeType;

    protected CRMainSceneBuilder(VRMLNodeFactory vRMLNodeFactory) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("The factory reference is null");
        }
        this.nodeFactory = vRMLNodeFactory;
        this.init = false;
        this.scriptStack = new SimpleStack();
        this.dontLoadTypes = new HashSet();
        this.ignoreDefSet = new HashSet();
        this.staticNodeSet = new HashSet();
        this.nodeStack = new VRMLNodeType[100];
        this.childIndexStack = new int[100];
    }

    public CRVRMLScene getScene() {
        return this.scene;
    }

    public void reset() {
        this.inScript = false;
        this.badFieldName = false;
        this.worldURL = null;
        this.dontLoadTypes.clear();
        this.ignoreDefSet.clear();
        this.staticNodeSet.clear();
        this.defMap.clear();
        this.protoMap.clear();
        this.externProtoMap.clear();
        this.inStatic = false;
        this.staticDepthCounter = 0;
    }

    public void setGlobals(Map map, Map map2, Map map3) {
        this.defMap = map == null ? new HashMap() : map;
        this.protoMap = map2 == null ? new HashMap() : map2;
        this.externProtoMap = map3 == null ? new HashMap() : map3;
        this.init = true;
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.isVrml97 = bl;
        if (!bl2) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLBackgroundNodeType == null ? (class$org$web3d$vrml$nodes$VRMLBackgroundNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLBackgroundNodeType")) : class$org$web3d$vrml$nodes$VRMLBackgroundNodeType));
        }
        if (!bl3) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLFogNodeType == null ? (class$org$web3d$vrml$nodes$VRMLFogNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLFogNodeType")) : class$org$web3d$vrml$nodes$VRMLFogNodeType));
        }
        if (!bl4) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLLightNodeType == null ? (class$org$web3d$vrml$nodes$VRMLLightNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLLightNodeType")) : class$org$web3d$vrml$nodes$VRMLLightNodeType));
        }
        if (!bl5) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLAudioClipNodeType == null ? (class$org$web3d$vrml$nodes$VRMLAudioClipNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLAudioClipNodeType")) : class$org$web3d$vrml$nodes$VRMLAudioClipNodeType));
        }
        if (!bl6) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLViewpointNodeType == null ? (class$org$web3d$vrml$nodes$VRMLViewpointNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLViewpointNodeType")) : class$org$web3d$vrml$nodes$VRMLViewpointNodeType));
        }
        if (!bl7) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLInlineNodeType == null ? (class$org$web3d$vrml$nodes$VRMLInlineNodeType = CRMainSceneBuilder.class$("org.web3d.vrml.nodes.VRMLInlineNodeType")) : class$org$web3d$vrml$nodes$VRMLInlineNodeType));
        }
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5) throws SAVException, VRMLException {
        if (string3.charAt(1) == 'V') {
            boolean bl = string4.charAt(1) == '2';
            int n = string2.equals("utf8") ? 2 : 1;
            this.metaData = new SceneMetaData(bl ? "2.0" : "1.0", true, n);
            this.metaData.setProfileName(VRML97_PROFILE_STRING);
            this.nodeFactory.setProfile(VRML97_PROFILE_STRING);
        } else {
            if (this.isVrml97) {
                throw new SAVException("Incompatible version for VRML97");
            }
            int n = string2.equals("utf8") ? 2 : 3;
            this.metaData = new SceneMetaData(string4, false, n);
        }
        this.version = string4.substring(1);
        this.root = this.nodeFactory.createVRMLNode("WorldRoot", string4, false);
        this.scene = new CRVRMLScene();
        this.scene.setWorldRootURL(string);
        this.scene.setMetaData(this.metaData);
        this.nodeStack[0] = this.root;
        this.childIndexStack[0] = this.root.getFieldIndex("children");
        this.topOfStack = 0;
        this.currentFieldIndex = 0;
        this.currentNode = this.root;
        this.scene.setRootNode(this.root);
        ((VRMLWorldRootNodeType)this.root).setContainedScene((BasicScene)this.scene);
        this.worldURL = string;
        this.inScript = false;
        if (this.locator == null) {
            this.locator = new DefaultLocator();
        }
        if (!this.init) {
            this.defMap = new HashMap();
            this.protoMap = new HashMap();
            this.externProtoMap = new HashMap();
            this.init = true;
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.nodeFactory.setProfile(string);
        this.metaData.setProfileName(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        Object object;
        int n = string.indexOf(58);
        String string2 = string;
        int n2 = -1;
        if (n != -1) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Component level is malformed");
            }
        }
        object = this.nodeFactory.addComponent(string2, n2);
        this.metaData.addComponent(object);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        if (string2 != null) {
            this.metaData.addMetaData(string, string2);
        }
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLException("DEF name not known for inline import " + string);
        }
        this.scene.addImportedNode(string3, string, string2);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLException("DEF name not known for export " + string);
        }
        this.scene.addExportedNode(string2, string);
    }

    public void endDocument() throws SAVException, VRMLException {
        this.root.setupFinished();
        int n = 0;
        while (n < this.topOfStack) {
            this.nodeStack[n] = null;
            ++n;
        }
        this.topOfStack = 0;
        this.currentNode = null;
        this.currentScript = null;
        this.currentFieldIndex = -1;
    }

    public abstract void startNode(String var1, String var2) throws SAVException, VRMLException;

    public void endNode() throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            --this.ignoreNodeCounter;
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if (this.staticDepthCounter > 0) {
            --this.staticDepthCounter;
            if (this.staticDepthCounter == 0) {
                this.inStatic = false;
            }
        }
        this.nodeStack[this.topOfStack--] = null;
        this.currentNode = this.nodeStack[this.topOfStack];
        this.currentFieldIndex = this.childIndexStack[this.topOfStack];
    }

    public void startField(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        int n = this.nodeStack[this.topOfStack].getFieldIndex(string);
        if (n == -1) {
            this.badFieldName = true;
            throw new InvalidFieldException("Unknown field name: " + string);
        }
        this.currentFieldIndex = n;
        this.childIndexStack[this.topOfStack] = n;
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if (!string.equals("NULL")) {
            this.currentNode.setRawValue(this.currentFieldIndex, string);
        }
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if (stringArray.length != 0) {
            this.currentNode.setRawValue(this.currentFieldIndex, stringArray);
        }
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.ignoreDefSet.contains((Object)string)) {
            return;
        }
        if (!this.inStatic && this.staticNodeSet.contains((Object)string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + " Cannot USE a node that is under a static group. \"" + string + '\"');
        }
        if (this.inStatic && !this.staticNodeSet.contains((Object)string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + "Cannot USE a node under a StaticGroup that was not DEFd " + "under a StaticGroup \"" + string + '\"');
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE declares an unknown source node DEF \"" + string + '\"');
        }
        if (!(this.nodeStack[this.topOfStack] instanceof VRMLScriptNodeType) && !(this.nodeStack[this.topOfStack] instanceof VRMLProtoInstance)) {
            if (vRMLNodeType instanceof VRMLBindableNodeType) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
            }
            if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains bindable node(s). \"" + string + '\"');
            }
        }
        this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, vRMLNodeType);
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endProtoBody() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode;
        this.scriptStack.push((Object)this.currentScript);
        this.inScript = true;
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.scriptStack.pop();
        if (this.currentScript == null) {
            this.inScript = false;
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        boolean bl;
        if (!this.inScript) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Script declaration not in script!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        int n2 = this.currentScript.appendField(vRMLFieldDeclaration);
        int n3 = vRMLFieldDeclaration.getFieldType();
        boolean bl2 = bl = n3 == 9 || n3 == 10;
        if (n == 4 || n == 1) {
            if (bl) {
                this.currentFieldIndex = n2;
            } else if (object instanceof String) {
                this.currentScript.setRawValue(n2, (String)object);
            } else {
                this.currentScript.setRawValue(n2, (String[])object);
            }
        }
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        if (this.ignoreDefSet.contains((Object)string) || this.ignoreDefSet.contains((Object)string3)) {
            return;
        }
        if (this.staticNodeSet.contains((Object)string) || this.staticNodeSet.contains((Object)string3)) {
            throw new InvalidFieldConnectionException("ROUTE references a node under a StaticGroup");
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source node DEF: " + string);
        }
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.defMap.get(string3);
        if (vRMLNodeType2 == null) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node DEF: " + string3);
        }
        int n = vRMLNodeType.getFieldIndex(string2);
        if (n == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source node field DEF: " + string + "." + string2);
        }
        int n2 = vRMLNodeType2.getFieldIndex(string4);
        if (n2 == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node field DEF: " + string3 + "." + string4);
        }
        CRROUTE cRROUTE = new CRROUTE(vRMLNodeType, n, vRMLNodeType2, n2);
        this.scene.addRoute(cRROUTE);
    }

    protected final void resizeStack() {
        if (this.topOfStack + 1 == this.nodeStack.length) {
            int n = this.nodeStack.length;
            int n2 = n + 25;
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.nodeStack, 0, vRMLNodeTypeArray, 0, n);
            System.arraycopy(this.childIndexStack, 0, vRMLNodeTypeArray, 0, n);
            this.nodeStack = vRMLNodeTypeArray;
            this.childIndexStack = nArray;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

