/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.SceneGraphTraversalObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometricPropertyNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.CRProtoScene;
import org.web3d.vrml.renderer.CRROUTE;
import org.web3d.vrml.renderer.NodeCopier;
import org.web3d.vrml.renderer.ProtoCopier;

public abstract class CRProtoCreator
implements SceneGraphTraversalObserver {
    protected VRMLNodeFactory factory;
    protected SceneGraphTraverser traverser;
    protected CRProtoScene scene;
    protected FrameStateManager stateManager;
    protected HashMap nodeMap;
    protected CRProtoInstance protoInstance;
    protected NodeCopier nodeCopier;
    protected ProtoCopier protoCopier;
    protected SceneGraphTraversalObserver currentObserver;
    protected boolean isVRML97;
    protected String worldURL;

    public CRProtoCreator(VRMLNodeFactory vRMLNodeFactory, String string) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("No node factory supplied");
        }
        this.factory = vRMLNodeFactory;
        this.worldURL = string;
        this.traverser = new SceneGraphTraverser();
        this.traverser.setObserver((SceneGraphTraversalObserver)this);
        this.nodeMap = new HashMap();
        this.protoCopier = new ProtoCopier(this.factory, string);
    }

    public void fillinInstance(PrototypeDecl prototypeDecl, CRProtoInstance cRProtoInstance) {
        this.protoInstance = cRProtoInstance;
        List list = prototypeDecl.getAllFields();
        VRMLFieldDeclaration[] vRMLFieldDeclarationArray = new VRMLFieldDeclaration[list.size()];
        list.toArray(vRMLFieldDeclarationArray);
        int n = vRMLFieldDeclarationArray.length - 1;
        while (n >= 0) {
            int n2 = cRProtoInstance.getFieldIndex(vRMLFieldDeclarationArray[n].getName());
            if (n2 == -1) {
                try {
                    cRProtoInstance.appendField(vRMLFieldDeclarationArray[n]);
                }
                catch (FieldExistsException fieldExistsException) {
                    System.out.println("J3DProtoCreator: Field exists?");
                }
            }
            --n;
        }
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        cRProtoInstance.setNumBodyNodes(vRMLGroupingNodeType.getChildrenSize());
        cRProtoInstance.setBackFill(true);
        this.finishCreate(prototypeDecl);
        cRProtoInstance.setBackFill(false);
        cRProtoInstance.resendIS();
        cRProtoInstance.setComplete();
        cRProtoInstance.propagateSetupFinished();
    }

    public void groupingNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLGroupingNodeType vRMLGroupingNodeType2, boolean bl) {
        this.currentObserver.groupingNode(vRMLGroupingNodeType, vRMLGroupingNodeType2, bl);
    }

    public void inlineNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInlineNodeType vRMLInlineNodeType, boolean bl) {
        this.currentObserver.inlineNode(vRMLGroupingNodeType, vRMLInlineNodeType, bl);
    }

    public void lightNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLLightNodeType vRMLLightNodeType, boolean bl) {
        this.currentObserver.lightNode(vRMLGroupingNodeType, vRMLLightNodeType, bl);
    }

    public void bindableNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        this.currentObserver.bindableNode(vRMLGroupingNodeType, vRMLBindableNodeType, bl);
    }

    public void shapeNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLShapeNodeType vRMLShapeNodeType, boolean bl) {
        this.currentObserver.shapeNode(vRMLGroupingNodeType, vRMLShapeNodeType, bl);
    }

    public void appearanceNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLAppearanceNodeType vRMLAppearanceNodeType, boolean bl) {
        this.currentObserver.appearanceNode(vRMLShapeNodeType, vRMLAppearanceNodeType, bl);
    }

    public void materialNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLMaterialNodeType vRMLMaterialNodeType, boolean bl) {
        this.currentObserver.materialNode(vRMLAppearanceNodeType, vRMLMaterialNodeType, bl);
    }

    public void textureNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureNodeType vRMLTextureNodeType, boolean bl) {
        this.currentObserver.textureNode(vRMLAppearanceNodeType, vRMLTextureNodeType, bl);
    }

    public void textureTransformNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureTransformNodeType vRMLTextureTransformNodeType, boolean bl) {
        this.currentObserver.textureTransformNode(vRMLAppearanceNodeType, vRMLTextureTransformNodeType, bl);
    }

    public void geometryNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLGeometryNodeType vRMLGeometryNodeType, boolean bl) {
        this.currentObserver.geometryNode(vRMLShapeNodeType, vRMLGeometryNodeType, bl);
    }

    public void soundNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSoundNodeType vRMLSoundNodeType, boolean bl) {
        this.currentObserver.soundNode(vRMLGroupingNodeType, vRMLSoundNodeType, bl);
    }

    public void audioClipNode(VRMLSoundNodeType vRMLSoundNodeType, VRMLAudioClipNodeType vRMLAudioClipNodeType, boolean bl) {
        this.currentObserver.audioClipNode(vRMLSoundNodeType, vRMLAudioClipNodeType, bl);
    }

    public void interpolatorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInterpolatorNodeType vRMLInterpolatorNodeType, boolean bl) {
        this.currentObserver.interpolatorNode(vRMLGroupingNodeType, vRMLInterpolatorNodeType, bl);
    }

    public void sensorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSensorNodeType vRMLSensorNodeType, boolean bl) {
        this.currentObserver.sensorNode(vRMLGroupingNodeType, vRMLSensorNodeType, bl);
    }

    public void scriptNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLScriptNodeType vRMLScriptNodeType, boolean bl) {
        this.currentObserver.scriptNode(vRMLGroupingNodeType, vRMLScriptNodeType, bl);
    }

    public void geometricPropertyNode(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType, VRMLGeometricPropertyNodeType vRMLGeometricPropertyNodeType, boolean bl) {
        this.currentObserver.geometricPropertyNode(vRMLComponentGeometryNodeType, vRMLGeometricPropertyNodeType, bl);
    }

    public void customNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        this.currentObserver.customNode(vRMLNodeType, n, vRMLNodeType2, bl);
    }

    public void miscellaneousNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        this.currentObserver.miscellaneousNode(vRMLNodeType, n, vRMLNodeType2, bl);
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        this.protoCopier.setFrameStateManager(frameStateManager);
    }

    protected void finishCreate(PrototypeDecl prototypeDecl) {
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        this.scene = new CRProtoScene();
        this.protoCopier.copyNode(this.protoInstance, this.scene, this.nodeMap, this.isVRML97 ? "2.0" : "3.0", false);
        this.currentObserver = this.protoCopier;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
        this.traverser.reset();
        int n = 0;
        while (n < vRMLNodeTypeArray.length) {
            this.traverser.traverseGraph(vRMLNodeTypeArray[n]);
            ++n;
        }
        this.traverser.reset();
        this.processRoutes(prototypeDecl.getRouteDecls());
        this.processIS(prototypeDecl.getISMaps(), prototypeDecl);
        this.processFields(prototypeDecl);
        this.protoInstance.setContainedScene(this.scene);
        this.nodeMap.clear();
    }

    private void processRoutes(Set set) {
        if (set.size() == 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ROUTE rOUTE = (ROUTE)iterator.next();
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeMap.get(rOUTE.getSourceNode());
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(rOUTE.getDestinationNode());
            VRMLNode vRMLNode = rOUTE.getSourceNode();
            int n = rOUTE.getSourceIndex();
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(n);
            n = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName());
            vRMLNode = rOUTE.getDestinationNode();
            int n2 = rOUTE.getDestinationIndex();
            vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(n2);
            n2 = vRMLNodeType2.getFieldIndex(vRMLFieldDeclaration.getName());
            if (n < 0 || n2 < 0) {
                System.out.println("MISMATCH between NR and J3D field names: " + vRMLNode + " field: " + vRMLFieldDeclaration.getName());
            }
            CRROUTE cRROUTE = new CRROUTE(vRMLNodeType, n, vRMLNodeType2, n2);
            this.scene.addRoute(cRROUTE);
        }
    }

    private void processIS(Map map, PrototypeDecl prototypeDecl) {
        if (map.size() == 0) {
            return;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = n;
            VRMLFieldDeclaration vRMLFieldDeclaration = prototypeDecl.getFieldDeclaration(n2);
            int n3 = this.protoInstance.getFieldIndex(vRMLFieldDeclaration.getName());
            List list = (List)map.get(n);
            Iterator iterator2 = list.iterator();
            ArrayList<ProtoFieldInfo> arrayList = new ArrayList<ProtoFieldInfo>(list.size());
            while (iterator2.hasNext()) {
                ProtoFieldInfo protoFieldInfo = (ProtoFieldInfo)iterator2.next();
                VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeMap.get(protoFieldInfo.node);
                if (vRMLNodeType == null) {
                    System.out.println("Invalid dest node: " + protoFieldInfo);
                    System.out.println("IS ignored");
                    continue;
                }
                vRMLFieldDeclaration = protoFieldInfo.node.getFieldDeclaration(protoFieldInfo.field);
                if (vRMLFieldDeclaration == null) {
                    System.out.println("Invalid source field for: " + protoFieldInfo.node);
                    System.out.println("IS ignored");
                    continue;
                }
                int n4 = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName());
                ProtoFieldInfo protoFieldInfo2 = new ProtoFieldInfo(vRMLNodeType, n4);
                arrayList.add(protoFieldInfo2);
            }
            this.protoInstance.setIsMapping(n3, arrayList);
        }
    }

    private void processFields(PrototypeDecl prototypeDecl) {
        List list = prototypeDecl.getAllFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            int n = vRMLFieldDeclaration.getAccessType();
            if (n == 2 || n == 3) continue;
            try {
                VRMLNodeType[] vRMLNodeTypeArray;
                String string = vRMLFieldDeclaration.getName();
                int n2 = prototypeDecl.getFieldIndex(string);
                int n3 = this.protoInstance.getFieldIndex(string);
                Object object = prototypeDecl.getFieldValue(n2);
                if (object instanceof String) {
                    this.protoInstance.setRawValue(n3, (String)object);
                    continue;
                }
                if (object instanceof String[]) {
                    this.protoInstance.setRawValue(n3, (String[])object);
                    continue;
                }
                if (!(object instanceof List)) continue;
                List list2 = (List)object;
                if (list2.size() == 1) {
                    vRMLNodeTypeArray = (VRMLNodeType[])list2.get(0);
                    VRMLNodeType vRMLNodeType = this.processNodeField((VRMLNodeType)vRMLNodeTypeArray);
                    this.protoInstance.setValue(n3, vRMLNodeType);
                    continue;
                }
                vRMLNodeTypeArray = new VRMLNodeType[list2.size()];
                list2.toArray(vRMLNodeTypeArray);
                vRMLNodeTypeArray = this.processNodeField(vRMLNodeTypeArray);
                this.protoInstance.setValue(n3, vRMLNodeTypeArray);
            }
            catch (FieldException fieldException) {
                System.out.println("Proto create field types don't match!");
                fieldException.printStackTrace();
            }
        }
    }

    protected void setProtoField(VRMLNodeType vRMLNodeType, int n, VRMLFieldData vRMLFieldData) throws FieldException {
        switch (vRMLFieldData.dataType) {
            case 1: {
                vRMLNodeType.setValue(n, vRMLFieldData.booleanValue);
                break;
            }
            case 8: {
                vRMLNodeType.setValue(n, vRMLFieldData.booleanArrayValue);
                break;
            }
            case 2: {
                vRMLNodeType.setValue(n, vRMLFieldData.intValue);
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, vRMLFieldData.intArrayValue);
                break;
            }
            case 3: {
                vRMLNodeType.setValue(n, vRMLFieldData.longValue);
                break;
            }
            case 10: {
                vRMLNodeType.setValue(n, vRMLFieldData.longArrayValue);
                break;
            }
            case 4: {
                vRMLNodeType.setValue(n, vRMLFieldData.floatValue);
                break;
            }
            case 11: {
                vRMLNodeType.setValue(n, vRMLFieldData.floatArrayValue);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, vRMLFieldData.doubleValue);
                break;
            }
            case 12: {
                vRMLNodeType.setValue(n, vRMLFieldData.doubleArrayValue);
                break;
            }
            case 6: {
                vRMLNodeType.setValue(n, vRMLFieldData.stringValue);
                break;
            }
            case 14: {
                vRMLNodeType.setValue(n, vRMLFieldData.stringArrayValue);
                break;
            }
            case 7: {
                if (vRMLFieldData.nodeValue == null) break;
                vRMLNodeType.setValue(n, this.processNodeField((VRMLNodeType)vRMLFieldData.nodeValue));
                break;
            }
            case 13: {
                if (vRMLFieldData.nodeArrayValue == null || vRMLFieldData.nodeArrayValue.length == 0) break;
                vRMLNodeType.setValue(n, this.processNodeField((VRMLNodeType[])vRMLFieldData.nodeArrayValue));
            }
        }
    }

    private VRMLNodeType processNodeField(VRMLNodeType vRMLNodeType) {
        if (this.nodeCopier == null) {
            this.nodeCopier = new NodeCopier(this.factory, this.worldURL);
        }
        CRProtoScene cRProtoScene = new CRProtoScene();
        this.currentObserver = this.nodeCopier;
        VRMLNodeType vRMLNodeType2 = this.nodeCopier.copyNode(vRMLNodeType, cRProtoScene, this.isVRML97 ? "2.0" : "3.0", false);
        this.traverser.traverseGraph(vRMLNodeType);
        return vRMLNodeType2;
    }

    private VRMLNodeType[] processNodeField(VRMLNodeType[] vRMLNodeTypeArray) {
        if (this.nodeCopier == null) {
            this.nodeCopier = new NodeCopier(this.factory, this.worldURL);
        }
        this.currentObserver = this.nodeCopier;
        CRProtoScene cRProtoScene = new CRProtoScene();
        VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[vRMLNodeTypeArray.length];
        System.out.println("Proto contains nodes in the declaration. We must do something about processing the scene generated");
        int n = 0;
        while (n < vRMLNodeTypeArray.length) {
            vRMLNodeTypeArray2[n] = this.nodeCopier.copyNode(vRMLNodeTypeArray[n], cRProtoScene, this.isVRML97 ? "2.0" : "3.0", false);
            this.traverser.traverseGraph(vRMLNodeTypeArray[n]);
            ++n;
        }
        return vRMLNodeTypeArray2;
    }
}

