/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.ProtoScene;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.parser.FieldParserFactory;
import org.web3d.vrml.parser.VRMLFieldReader;

public class CRProtoInstance
implements VRMLProtoInstance,
VRMLNodeType {
    private static final String SET_PREFIX = "set_";
    private static final String CHANGE_SUFFIX = "_changed";
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    protected boolean isStatic;
    protected String vrmlVersion;
    protected boolean[] hasChanged;
    protected static VRMLFieldReader fieldParser;
    protected Map fieldIndexMap;
    protected List fieldDeclList;
    protected final String nodeName;
    protected VRMLFieldData fieldData;
    private IntHashMap userData;
    private VRMLNodeListener nodeListener;
    protected VRMLNodeType[] bodyNodes;
    protected int bodyNodeCount;
    protected VRMLNodeType rootNode;
    protected ProtoScene sceneInfo;
    protected FrameStateManager stateManager;
    protected IntHashMap isMap;
    protected IntHashMap fieldValueMap;
    protected IntHashMap fieldChangedMap;
    protected boolean isDEF;
    protected boolean inSetup;
    protected boolean isVrml97;
    private boolean backFill;
    protected int lastFieldIndex;
    protected int[] isListEntry;
    protected int refCount;
    private int[] secondaryType;
    protected boolean completeBody;
    private IntHashMap lostList;
    private boolean delayedAdd;

    protected CRProtoInstance(String string, boolean bl, VRMLFieldDeclaration[] vRMLFieldDeclarationArray, int n) {
        this.nodeName = string;
        this.lastFieldIndex = vRMLFieldDeclarationArray.length;
        this.isVrml97 = bl;
        this.secondaryType = TypeConstants.NO_SECONDARY_TYPE;
        this.fieldIndexMap = new HashMap(this.lastFieldIndex, 1.0f);
        this.fieldDeclList = new ArrayList(this.lastFieldIndex);
        this.userData = new IntHashMap(this.lastFieldIndex);
        this.bodyNodes = new VRMLNodeType[n];
        this.fieldData = new VRMLFieldData();
        int n2 = 0;
        while (n2 < vRMLFieldDeclarationArray.length) {
            this.fieldDeclList.add(vRMLFieldDeclarationArray[n2]);
            if (vRMLFieldDeclarationArray[n2] != null) {
                String string2 = vRMLFieldDeclarationArray[n2].getName();
                Integer n3 = new Integer(n2);
                this.fieldIndexMap.put(string2, n3);
                if (vRMLFieldDeclarationArray[n2].getAccessType() == 1) {
                    if (!string2.startsWith(SET_PREFIX)) {
                        this.fieldIndexMap.put(SET_PREFIX + string2, n3);
                    }
                    if (!string2.endsWith(CHANGE_SUFFIX)) {
                        this.fieldIndexMap.put(string2 + CHANGE_SUFFIX, n3);
                    }
                }
            }
            ++n2;
        }
        this.isDEF = false;
        this.inSetup = true;
        this.backFill = false;
        this.isMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.fieldValueMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.fieldChangedMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.completeBody = false;
        this.lostList = new IntHashMap();
        this.delayedAdd = false;
        this.hasChanged = new boolean[vRMLFieldDeclarationArray.length];
    }

    protected int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.get(string);
        if (n != null) {
            VRMLFieldDeclaration vRMLFieldDeclaration2 = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType() || vRMLFieldDeclaration.getAccessType() != vRMLFieldDeclaration.getAccessType()) {
                throw new FieldExistsException("Can't add here", string);
            }
        }
        this.fieldIndexMap.put(string, new Integer(this.lastFieldIndex));
        this.fieldDeclList.add(vRMLFieldDeclaration);
        return this.lastFieldIndex++;
    }

    public VRMLNodeType getImplementationNode() {
        if (!this.completeBody) {
            return null;
        }
        if (this.rootNode == null && this.bodyNodeCount != 0) {
            this.rootNode = this.bodyNodes[0];
        }
        return this.rootNode;
    }

    public int getFieldCount() {
        return this.fieldDeclList.size();
    }

    public List getAllFields() {
        return this.fieldDeclList;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public synchronized int updateRefCount(boolean bl) {
        int n = this.refCount++;
        return n;
    }

    public void setupFinished() {
        if (!this.inSetup || !this.completeBody) {
            return;
        }
        int[] nArray = this.lostList.keySet();
        int n = 0;
        while (n < nArray.length) {
            ArrayList arrayList = (ArrayList)this.lostList.get(nArray[n]);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList.get(n2);
                VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.fieldValueMap.get(nArray[n]);
                ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(nArray[n]);
                if (protoFieldInfoArray != null) {
                    int n3 = 0;
                    while (n3 < protoFieldInfoArray.length) {
                        protoFieldInfoArray[n3].node.notifyExternProtoLoaded(protoFieldInfoArray[n3].field, vRMLNodeType);
                        ++n3;
                    }
                }
                ++n2;
            }
            arrayList.clear();
            ++n;
        }
        this.lostList.clear();
        this.lostList = null;
        if (this.stateManager != null) {
            this.delayedAdd = true;
        }
        this.isListEntry = new int[this.lastFieldIndex];
        this.propagateSetupFinished();
        this.inSetup = false;
        fieldParser = null;
        if (this.rootNode != null) {
            this.secondaryType = new int[]{this.rootNode.getPrimaryType()};
        }
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        if (this.delayedAdd) {
            this.stateManager.registerAddedScene((VRMLExecutionSpace)this);
            this.delayedAdd = false;
        }
    }

    public void allEventsComplete() {
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public void setVersion(String string, boolean bl) {
        this.vrmlVersion = string;
        this.isStatic = bl;
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public int getFieldIndex(String string) {
        int n = -1;
        Integer n2 = (Integer)this.fieldIndexMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return (VRMLFieldDeclaration)this.fieldDeclList.get(n);
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public boolean hasFieldChanged(int n) {
        Boolean bl;
        if (this.inSetup) {
            return false;
        }
        boolean bl2 = false;
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray != null) {
            int n2 = 0;
            while (n2 < protoFieldInfoArray.length) {
                bl2 = protoFieldInfoArray[n2].node.hasFieldChanged(protoFieldInfoArray[n2].field);
                if (bl2) {
                    this.isListEntry[n] = n2;
                    return true;
                }
                ++n2;
            }
        }
        if ((bl = (Boolean)this.fieldChangedMap.get(n)) != null && (bl2 = bl.booleanValue())) {
            this.fieldChangedMap.put(n, (Object)Boolean.FALSE);
        }
        return bl2;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(n, (VRMLNode)this);
        }
        Object object = this.fieldValueMap.get(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 1: {
                this.fieldData.intValue = (Integer)object;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 2: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.numElements = object != null ? this.fieldData.intArrayValue.length : 0;
                this.fieldData.dataType = (short)9;
                break;
            }
            case 3: {
                this.fieldData.floatValue = ((Float)object).floatValue();
                this.fieldData.dataType = (short)4;
                break;
            }
            case 4: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object != null ? this.fieldData.floatArrayValue.length : 0;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 5: {
                this.fieldData.doubleValue = (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 6: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object != null ? this.fieldData.doubleArrayValue.length : 0;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 19: {
                this.fieldData.longValue = ((Long)object).longValue();
                this.fieldData.dataType = (short)3;
                break;
            }
            case 20: {
                this.fieldData.longArrayValue = (long[])object;
                this.fieldData.numElements = object != null ? this.fieldData.longArrayValue.length : 0;
                this.fieldData.dataType = (short)10;
                break;
            }
            case 21: {
                this.fieldData.booleanValue = (Boolean)object;
                this.fieldData.dataType = 1;
                break;
            }
            case 22: {
                this.fieldData.booleanArrayValue = (boolean[])object;
                this.fieldData.numElements = object != null ? this.fieldData.booleanArrayValue.length : 0;
                this.fieldData.dataType = (short)8;
                break;
            }
            case 7: {
                this.fieldData.doubleValue = (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 8: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object != null ? this.fieldData.doubleArrayValue.length : 0;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 23: {
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 24: {
                if (object instanceof String[]) {
                    this.fieldData.stringArrayValue = (String[])object;
                    this.fieldData.numElements = object != null ? this.fieldData.stringArrayValue.length : 0;
                    this.fieldData.dataType = (short)14;
                    break;
                }
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 9: {
                this.fieldData.nodeValue = (VRMLNodeType)object;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 10: {
                if (object instanceof VRMLNodeType) {
                    this.fieldData.nodeArrayValue = new VRMLNodeType[1];
                    this.fieldData.nodeArrayValue[0] = (VRMLNodeType)object;
                } else {
                    this.fieldData.nodeArrayValue = (VRMLNodeType[])object;
                }
                this.fieldData.numElements = object != null ? this.fieldData.nodeArrayValue.length : 0;
                this.fieldData.dataType = (short)13;
                break;
            }
            case 11: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 2 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 12: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object != null ? this.fieldData.floatArrayValue.length / 2 : 0;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 13: 
            case 27: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 3 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 25: 
            case 29: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 4 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 14: 
            case 28: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object != null ? this.fieldData.floatArrayValue.length / 3 : 0;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 26: 
            case 30: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object != null ? this.fieldData.floatArrayValue.length / 4 : 0;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 15: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 3 ? 0 : 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 16: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object != null ? this.fieldData.doubleArrayValue.length / 3 : 0;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 17: 
            case 18: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.numElements = object != null ? this.fieldData.intArrayValue.length : 0;
                this.fieldData.dataType = (short)9;
            }
        }
        return this.fieldData;
    }

    public int getPrimaryType() {
        return 38;
    }

    public int[] getSecondaryType() {
        return this.secondaryType;
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            ArrayList<VRMLNodeType> arrayList = (ArrayList<VRMLNodeType>)this.lostList.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<VRMLNodeType>();
                arrayList.add(vRMLNodeType);
                this.lostList.put(n, arrayList);
            } else {
                arrayList.add(vRMLNodeType);
            }
            return;
        }
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.fieldValueMap.get(n);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.notifyExternProtoLoaded(protoFieldInfoArray[n2].field, vRMLNodeType);
            ++n2;
        }
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        Object object = this.fieldValueMap.get(n);
        if (object == null) {
            int n3 = this.isListEntry[n];
            ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
            if (protoFieldInfoArray != null) {
                VRMLFieldData vRMLFieldData = protoFieldInfoArray[this.isListEntry[n3]].node.getFieldValue(protoFieldInfoArray[n3].field);
                switch (vRMLFieldData.dataType) {
                    case 1: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.booleanValue);
                        break;
                    }
                    case 8: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.booleanArrayValue);
                        break;
                    }
                    case 2: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.intValue);
                        break;
                    }
                    case 9: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.intArrayValue);
                        break;
                    }
                    case 3: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.longValue);
                        break;
                    }
                    case 10: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.longArrayValue);
                        break;
                    }
                    case 4: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.floatValue);
                        break;
                    }
                    case 11: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.floatArrayValue);
                        break;
                    }
                    case 5: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.doubleValue);
                        break;
                    }
                    case 12: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.doubleArrayValue);
                        break;
                    }
                    case 6: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.stringValue);
                        break;
                    }
                    case 14: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.stringArrayValue);
                        break;
                    }
                    case 7: {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)vRMLFieldData.nodeValue);
                        break;
                    }
                    case 13: {
                        vRMLNodeType.setValue(n2, (VRMLNodeType[])vRMLFieldData.nodeArrayValue);
                    }
                }
            }
            return;
        }
        try {
            this.sendValue(vRMLNodeType, n2, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Route to invalid event: " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Route sending out of range values " + invalidFieldValueException.getFieldName());
        }
    }

    public void setRawValue(int n, String string) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        this.createFieldParser();
        if (this.isVrml97) {
            switch (vRMLFieldDeclaration.getFieldType()) {
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 29: 
                case 30: {
                    throw new InvalidFieldException(VRML97_FIELD_MSG + vRMLFieldDeclaration.getFieldTypeString());
                }
            }
        }
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 23: {
                this.setValue(n, fieldParser.SFString(string));
                break;
            }
            case 1: {
                this.setValue(n, fieldParser.SFInt32(string));
                break;
            }
            case 2: {
                this.setValue(n, fieldParser.MFInt32(string));
                break;
            }
            case 17: {
                this.setValue(n, fieldParser.SFImage(string));
                break;
            }
            case 3: {
                this.setValue(n, fieldParser.SFFloat(string));
                break;
            }
            case 7: {
                this.setValue(n, fieldParser.SFTime(string));
                break;
            }
            case 5: {
                this.setValue(n, fieldParser.SFDouble(string));
                break;
            }
            case 8: {
                this.setValue(n, fieldParser.MFTime(string));
                break;
            }
            case 6: {
                this.setValue(n, fieldParser.MFDouble(string));
                break;
            }
            case 19: {
                this.setValue(n, fieldParser.SFLong(string));
                break;
            }
            case 20: {
                this.setValue(n, fieldParser.MFLong(string));
                break;
            }
            case 21: {
                this.setValue(n, fieldParser.SFBool(string));
                break;
            }
            case 22: {
                this.setValue(n, fieldParser.MFBool(string));
                break;
            }
            case 4: {
                this.setValue(n, fieldParser.MFFloat(string));
                break;
            }
            case 11: {
                this.setValue(n, fieldParser.SFVec2f(string));
                break;
            }
            case 13: {
                this.setValue(n, fieldParser.SFVec3f(string));
                break;
            }
            case 27: {
                this.setValue(n, fieldParser.SFColor(string));
                break;
            }
            case 29: {
                this.setValue(n, fieldParser.SFColorRGBA(string));
                break;
            }
            case 12: {
                this.setValue(n, fieldParser.MFVec2f(string));
                break;
            }
            case 14: {
                this.setValue(n, fieldParser.MFVec3f(string));
                break;
            }
            case 28: {
                this.setValue(n, fieldParser.MFColor(string));
                break;
            }
            case 30: {
                this.setValue(n, fieldParser.MFColor(string));
                break;
            }
            case 15: {
                this.setValue(n, fieldParser.SFVec3d(string));
                break;
            }
            case 16: {
                this.setValue(n, fieldParser.MFVec3d(string));
                break;
            }
            case 18: {
                this.setValue(n, fieldParser.MFImage(string));
                break;
            }
            case 24: {
                this.setValue(n, fieldParser.MFString(string));
                break;
            }
            case 25: {
                this.setValue(n, fieldParser.SFRotation(string));
                break;
            }
            case 26: {
                this.setValue(n, fieldParser.MFRotation(string));
                break;
            }
            default: {
                System.out.println("Unhandled fieldType in  CRProtoInstance");
            }
        }
    }

    public void setRawValue(int n, String[] stringArray) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        if (stringArray.length == 0) {
            return;
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        this.createFieldParser();
        try {
            this.setValue(n, fieldParser.MFString(stringArray), stringArray);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("ProtoInstance: ");
            stringBuffer.append(this.getFieldDeclaration(n));
            stringBuffer.append('\n');
            stringBuffer.append(exception.getMessage());
            throw new InvalidFieldFormatException(stringBuffer.toString());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                n2 = (Integer)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)new Integer(n2));
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)new Integer(n2));
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n3].node.setValue(protoFieldInfoArray[n3].field, n2);
            ++n3;
        }
    }

    public void setValue(int n, int[] nArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                nArray = (int[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)nArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)nArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, nArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                l = (Long)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)new Long(l));
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)new Long(l));
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, l);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, long[] lArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                lArray = (long[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)lArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)lArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, lArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                bl = (Boolean)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)new Boolean(bl));
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)new Boolean(bl));
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, bl);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, boolean[] blArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                blArray = (boolean[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)blArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)blArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, blArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                f = ((Float)protoFieldInfoArray).floatValue();
            } else {
                this.fieldValueMap.put(n, (Object)new Float(f));
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)new Float(f));
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, f);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, float[] fArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                fArray = (float[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)fArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)fArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, fArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, float[][] fArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                fArray = (float[][])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)fArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)fArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, fArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                d = (Double)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)new Double(d));
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)new Double(d));
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, d);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, double[] dArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                dArray = (double[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)dArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)dArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, dArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, double[][] dArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                dArray = (double[][])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)dArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)dArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, dArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                string = (String)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)string);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)string);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, string);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, String[] stringArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                stringArray = protoFieldInfoArray instanceof String ? new String[]{(String)protoFieldInfoArray} : (String[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)stringArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)stringArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, stringArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        VRMLGroupingNodeType vRMLGroupingNodeType;
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                vRMLNodeType = (VRMLNodeType)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)vRMLNodeType);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)vRMLNodeType);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            vRMLGroupingNodeType = (VRMLGroupingNodeType)vRMLNodeType;
            int n2 = 0;
            while (n2 < protoFieldInfoArray.length) {
                vRMLGroupingNodeType.setShared(true);
                ++n2;
            }
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (vRMLNodeType2 = (vRMLGroupingNodeType = (VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLGroupingNodeType) {
            VRMLGroupingNodeType vRMLGroupingNodeType2 = (VRMLGroupingNodeType)vRMLNodeType2;
            int n3 = 0;
            while (n3 < protoFieldInfoArray.length) {
                vRMLGroupingNodeType2.setShared(true);
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n4].node.setValue(protoFieldInfoArray[n4].field, vRMLNodeType);
            if (protoFieldInfoArray[n4].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n4].node).cascadeComplete();
            }
            ++n4;
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                vRMLNodeTypeArray = (VRMLNodeType[])protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray);
                this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            }
        } else {
            this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray);
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            int n3 = 0;
            while (n3 < vRMLNodeTypeArray.length) {
                VRMLNodeType vRMLNodeType;
                VRMLGroupingNodeType vRMLGroupingNodeType;
                VRMLNodeType vRMLNodeType2 = vRMLNodeTypeArray[n3];
                if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                    vRMLGroupingNodeType = (VRMLGroupingNodeType)vRMLNodeType2;
                    int n4 = 0;
                    while (n4 < protoFieldInfoArray.length) {
                        vRMLGroupingNodeType.setShared(true);
                        ++n4;
                    }
                } else if (vRMLNodeType2 instanceof VRMLProtoInstance && (vRMLNodeType = (vRMLGroupingNodeType = (VRMLProtoInstance)vRMLNodeType2).getImplementationNode()) instanceof VRMLGroupingNodeType) {
                    VRMLGroupingNodeType vRMLGroupingNodeType2 = (VRMLGroupingNodeType)vRMLNodeType;
                    int n5 = 0;
                    while (n5 < protoFieldInfoArray.length) {
                        vRMLGroupingNodeType2.setShared(true);
                        ++n5;
                    }
                }
                ++n3;
            }
            protoFieldInfoArray[n2].node.setValue(protoFieldInfoArray[n2].field, vRMLNodeTypeArray);
            if (protoFieldInfoArray[n2].node instanceof VRMLScriptNodeType && !this.inSetup) {
                ((VRMLScriptNodeType)protoFieldInfoArray[n2].node).cascadeComplete();
            }
            ++n2;
        }
    }

    public BasicScene getContainedScene() {
        return this.sceneInfo;
    }

    void addBodyChild(VRMLNodeType vRMLNodeType) {
        this.bodyNodes[this.bodyNodeCount] = vRMLNodeType;
        ++this.bodyNodeCount;
    }

    void setNumBodyNodes(int n) {
        if (this.bodyNodeCount != 0) {
            throw new IllegalStateException("Cannot set numBodyCount after adding children");
        }
        this.bodyNodes = new VRMLNodeType[n];
    }

    void setBackFill(boolean bl) {
        this.backFill = bl;
    }

    public void setComplete() {
        this.completeBody = true;
    }

    public boolean getComplete() {
        return this.completeBody;
    }

    void setIsMapping(int n, List list) {
        int n2 = list.size();
        ProtoFieldInfo[] protoFieldInfoArray = new ProtoFieldInfo[n2];
        list.toArray(protoFieldInfoArray);
        this.isMap.put(n, (Object)protoFieldInfoArray);
    }

    void resendIS() {
        Iterator iterator = this.fieldIndexMap.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            ProtoFieldInfo[] protoFieldInfoArray;
            int n = (Integer)iterator.next();
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            int n2 = vRMLFieldDeclaration.getAccessType();
            if (n2 == 2 || n2 == 3 || (protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n)) == null || (object = this.fieldValueMap.get(n)) == null) continue;
            try {
                this.sendValue(this, n, object);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                invalidFieldValueException.printStackTrace();
            }
            catch (InvalidFieldException invalidFieldException) {
                invalidFieldException.printStackTrace();
            }
        }
    }

    void setContainedScene(ProtoScene protoScene) {
        this.sceneInfo = protoScene;
        if (this.rootNode == null && this.bodyNodeCount != 0) {
            this.rootNode = this.bodyNodes[0];
        }
        if (this.isDEF) {
            this.rootNode.setDEF();
        }
    }

    void propagateSetupFinished() {
        if (!this.completeBody) {
            return;
        }
        if (this.rootNode == null) {
            return;
        }
        int n = this.getFieldCount();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n2);
            int n4 = vRMLFieldDeclaration.getAccessType();
            if (n4 != 2 && n4 != 3 && (n3 = vRMLFieldDeclaration.getFieldType()) == 10 && n3 == 9) {
                VRMLNodeType[] vRMLNodeTypeArray;
                Object object = this.fieldValueMap.get(n2);
                if (object instanceof VRMLNodeType) {
                    vRMLNodeTypeArray = (VRMLNodeType[])object;
                    vRMLNodeTypeArray.setupFinished();
                } else if (object instanceof VRMLNodeType[]) {
                    vRMLNodeTypeArray = (VRMLNodeType[])object;
                    int n5 = 0;
                    while (n5 < vRMLNodeTypeArray.length) {
                        vRMLNodeTypeArray[n2].setupFinished();
                        ++n5;
                    }
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.bodyNodes.length) {
            this.bodyNodes[n2].setupFinished();
            ++n2;
        }
    }

    private void sendValue(VRMLNodeType vRMLNodeType, int n, Object object) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 1: {
                vRMLNodeType.setValue(n, ((Integer)object).intValue());
                break;
            }
            case 2: 
            case 17: 
            case 18: {
                vRMLNodeType.setValue(n, (int[])object);
                break;
            }
            case 3: {
                vRMLNodeType.setValue(n, ((Float)object).floatValue());
                break;
            }
            case 5: 
            case 7: {
                vRMLNodeType.setValue(n, ((Double)object).doubleValue());
                break;
            }
            case 6: 
            case 8: {
                vRMLNodeType.setValue(n, (double[])object);
                break;
            }
            case 19: {
                vRMLNodeType.setValue(n, ((Long)object).longValue());
                break;
            }
            case 20: {
                vRMLNodeType.setValue(n, (long[])object);
                break;
            }
            case 21: {
                vRMLNodeType.setValue(n, ((Boolean)object).booleanValue());
                break;
            }
            case 22: {
                vRMLNodeType.setValue(n, (boolean[])object);
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, (VRMLNodeType)object);
                break;
            }
            case 10: {
                if (object instanceof VRMLNodeType) {
                    vRMLNodeType.setValue(n, (VRMLNodeType)object);
                    break;
                }
                vRMLNodeType.setValue(n, (VRMLNodeType[])object);
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 25: 
            case 27: 
            case 29: {
                vRMLNodeType.setValue(n, (float[])object);
                break;
            }
            case 12: 
            case 14: 
            case 26: 
            case 28: 
            case 30: {
                if (object instanceof float[]) {
                    vRMLNodeType.setValue(n, (float[])object);
                    break;
                }
                if (!(object instanceof float[][])) break;
                vRMLNodeType.setValue(n, (float[][])object);
                break;
            }
            case 15: {
                vRMLNodeType.setValue(n, (double[])object);
                break;
            }
            case 16: {
                if (object instanceof double[]) {
                    vRMLNodeType.setValue(n, (double[])object);
                    break;
                }
                if (!(object instanceof double[][])) break;
                vRMLNodeType.setValue(n, (double[][])object);
                break;
            }
            case 24: {
                vRMLNodeType.setValue(n, (String[])object);
                break;
            }
            case 23: {
                vRMLNodeType.setValue(n, (String)object);
                break;
            }
            default: {
                System.out.println("Unhandled case in CRProtoInstance.sendValue: " + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
    }

    public void setValue(int n, int n2, String string) throws InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)new Integer(n2));
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n3].node.setRawValue(protoFieldInfoArray[n3].field, string);
            ++n3;
        }
    }

    public void setValue(int n, int[] nArray, String string) throws InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)nArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, long l, String string) throws InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)new Long(l));
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, long[] lArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)lArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, boolean bl, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, boolean[] blArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)blArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, float f, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)new Float(f));
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, float[] fArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)fArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, float[][] fArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)fArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, double d, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)new Double(d));
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, double[] dArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)dArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, double[][] dArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)dArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, String string, String string2) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)string);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string2);
            ++n2;
        }
    }

    public void setValue(int n, String[] stringArray, String string) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)stringArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, string);
            ++n2;
        }
    }

    public void setValue(int n, String[] stringArray, String[] stringArray2) throws InvalidFieldException, InvalidFieldValueException {
        this.fieldValueMap.put(n, (Object)stringArray);
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < protoFieldInfoArray.length) {
            protoFieldInfoArray[n2].node.setRawValue(protoFieldInfoArray[n2].field, stringArray2);
            ++n2;
        }
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    protected void createFieldParser() {
        if (fieldParser == null) {
            FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
            fieldParser = fieldParserFactory.newFieldParser(this.vrmlVersion);
        }
    }

    protected void fireFieldChanged(int n) {
        block2: {
            if (this.nodeListener == null) break block2;
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

