/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.ProfileInfo;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;

public class DefaultNodeFactory
implements VRMLNodeFactory {
    public static final String JAVA3D_RENDERER = "java3d";
    public static final String NULL_RENDERER = "null";
    public static final String OPENGL_RENDERER = "ogl";
    public static final String MOBILE_RENDERER = "mobile";
    private static final int INC_SIZE = 4;
    private static final String PROPERTY_FILE = "xj3d.properties";
    private static final String[] SUPPORTED_PROFILES;
    private static final Class[] NODE_CLASS;
    private static final String NO_COMP_DEF_MSG = "There is no definition information for the component ";
    private static final String NO_COMP_FILE_MSG = "Could not find the definition file for the component ";
    private static final String NO_PROF_FILE_MSG = "Could not find the definition file for the profile ";
    private static final String CREATE_MSG = "New node instantiation exception";
    private static final String ACCESS_MSG = "New now IllegalAccess exception";
    private static final String COPY_CON_MSG = "Node without copy constructor: ";
    private static final String EXCEPT_CON_MSG = "Exception in copy constructor: ";
    private static final String NO_COMP_LVL_MSG = "The component does not support the level requested ";
    private static HashMap factoryInstances;
    private static HashSet availableProfiles;
    private static HashMap loadedProfiles;
    private static HashMap rendererPrefixMap;
    private static HashMap rendererPackageMap;
    private static HashMap componentFileMap;
    private static boolean componentDefsLoaded;
    private static HashMap componentLevels;
    private static HashMap loadedComponents;
    private static HashMap nodeNameComponentMap;
    private static HashMap nodeNameLevelMap;
    private static HashMap nodeClassMap;
    private static HashMap constructorMap;
    private String[] usableComponents;
    private int[] usableLevels;
    private int numUsableComponents;
    private Object[] constructorArgs;
    private final String namePrefix;
    private final String basePackage;
    private final String renderer;
    private ErrorReporter reporter;
    private Properties properties;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLNodeType;

    protected DefaultNodeFactory(String string) {
        this.renderer = string;
        this.namePrefix = (String)rendererPrefixMap.get(string);
        this.basePackage = (String)rendererPackageMap.get(string);
        this.properties = new Properties();
        this.constructorArgs = new Object[1];
        this.reporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.reporter = errorReporter;
        if (errorReporter == null) {
            this.reporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setProfile(String string) throws UnsupportedProfileException {
        this.numUsableComponents = 0;
        ProfileInfo profileInfo = (ProfileInfo)loadedProfiles.get(string);
        if (profileInfo == null) {
            profileInfo = this.loadProfile(string);
        }
        ComponentInfo[] componentInfoArray = profileInfo.getComponents();
        int n = componentInfoArray.length;
        if (this.usableComponents == null || this.usableComponents.length < n) {
            this.usableComponents = new String[n];
            this.usableLevels = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.usableComponents[n2] = componentInfoArray[n2].getName();
            this.usableLevels[n2] = componentInfoArray[n2].getLevel();
            ++n2;
        }
        this.numUsableComponents = n;
    }

    public ComponentInfo addComponent(String string, int n) throws UnsupportedComponentException {
        ComponentInfo componentInfo;
        if (!componentFileMap.containsKey(string)) {
            throw new UnsupportedComponentException(NO_COMP_DEF_MSG + string);
        }
        Integer n2 = (Integer)componentLevels.get(string);
        if (n2 == null) {
            n2 = this.loadComponent(string);
        }
        if (n != -1 && n2 < n) {
            throw new UnsupportedComponentException(NO_COMP_LVL_MSG + n);
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.numUsableComponents) {
            if (string.equals(this.usableComponents[n3])) {
                bl = true;
                if (this.usableLevels[n3] < n) {
                    this.usableLevels[n3] = n;
                }
            }
            ++n3;
        }
        if (!bl) {
            if (this.usableComponents == null) {
                this.usableComponents = new String[5];
                this.usableLevels = new int[5];
            } else if (this.numUsableComponents == this.usableComponents.length) {
                componentInfo = new String[this.numUsableComponents + 4];
                System.arraycopy(this.usableComponents, 0, componentInfo, 0, this.numUsableComponents);
                this.usableComponents = componentInfo;
                int[] nArray = new int[this.numUsableComponents + 4];
                System.arraycopy(this.usableLevels, 0, nArray, 0, this.numUsableComponents);
                this.usableLevels = nArray;
            }
            this.usableComponents[this.numUsableComponents] = string;
            this.usableLevels[this.numUsableComponents] = n;
            ++this.numUsableComponents;
        }
        componentInfo = (ComponentInfo)loadedComponents.get(string);
        if (n != -1 && componentInfo.getLevel() != n) {
            componentInfo = new ComponentInfo(componentInfo, n);
        }
        return componentInfo;
    }

    public String[] getAvailableProfiles() {
        return SUPPORTED_PROFILES;
    }

    public ComponentInfo[] getAvailableComponents() {
        ComponentInfo[] componentInfoArray = null;
        if (!componentDefsLoaded) {
            componentInfoArray = new ComponentInfo[componentFileMap.size()];
            int n = 0;
            Set set = componentFileMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ComponentInfo componentInfo = (ComponentInfo)loadedComponents.get(string);
                try {
                    if (componentInfo == null) {
                        this.loadComponent(string);
                        componentInfo = (ComponentInfo)loadedComponents.get(string);
                    }
                    componentInfoArray[n++] = componentInfo;
                }
                catch (UnsupportedComponentException unsupportedComponentException) {
                    this.reporter.warningReport("Bad component " + string, null);
                }
            }
            componentDefsLoaded = true;
        } else {
            Set set = loadedComponents.entrySet();
            Iterator iterator = set.iterator();
            componentInfoArray = new ComponentInfo[loadedComponents.size()];
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                componentInfoArray[n++] = (ComponentInfo)entry.getValue();
            }
        }
        return componentInfoArray;
    }

    public synchronized VRMLNodeType createVRMLNode(String string, String string2, boolean bl) {
        VRMLNodeType vRMLNodeType = null;
        try {
            Class clazz = this.findNode(string);
            if (clazz != null) {
                vRMLNodeType = (VRMLNodeType)clazz.newInstance();
                vRMLNodeType.setVersion(string2, bl);
            }
        }
        catch (InstantiationException instantiationException) {
            this.reporter.errorReport(CREATE_MSG, (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.reporter.errorReport(ACCESS_MSG, (Exception)illegalAccessException);
        }
        if (vRMLNodeType == null) {
            this.reporter.warningReport("Couldn't find class: " + string, null);
        }
        return vRMLNodeType;
    }

    public synchronized VRMLNodeType createVRMLNode(String string, String string2, String string3, boolean bl) throws UnsupportedComponentException {
        if (!componentFileMap.containsKey(string)) {
            throw new UnsupportedComponentException(string);
        }
        VRMLNodeType vRMLNodeType = null;
        ComponentInfo componentInfo = (ComponentInfo)loadedComponents.get(string);
        if (componentInfo == null) {
            this.loadComponent(string);
            componentInfo = (ComponentInfo)loadedComponents.get(string);
        }
        StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
        try {
            stringBuffer.append('.');
            stringBuffer.append(this.namePrefix);
            stringBuffer.append(string2);
            Class<?> clazz = Class.forName(stringBuffer.toString());
            vRMLNodeType = (VRMLNodeType)clazz.newInstance();
            vRMLNodeType.setVersion(string3, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            this.reporter.errorReport(CREATE_MSG, (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.reporter.errorReport(ACCESS_MSG, (Exception)illegalAccessException);
        }
        if (vRMLNodeType == null) {
            this.reporter.warningReport("Couldn't find class: " + string2, null);
        }
        return vRMLNodeType;
    }

    public synchronized VRMLNodeType createVRMLNode(VRMLNodeType vRMLNodeType, String string, boolean bl) {
        VRMLNodeType vRMLNodeType2 = null;
        String string2 = vRMLNodeType.getVRMLNodeName();
        ComponentInfo componentInfo = (ComponentInfo)nodeNameComponentMap.get(string2);
        StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
        stringBuffer.append('.');
        stringBuffer.append(this.namePrefix);
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        Constructor constructor = (Constructor)constructorMap.get(string3);
        try {
            Class clazz;
            if (constructor == null && (clazz = this.findNode(string2)) != null) {
                constructor = clazz.getConstructor(NODE_CLASS);
                constructorMap.put(string3, constructor);
            }
            if (constructor != null) {
                this.constructorArgs[0] = vRMLNodeType;
                vRMLNodeType2 = (VRMLNodeType)constructor.newInstance(this.constructorArgs);
                vRMLNodeType2.setVersion(string, bl);
                this.constructorArgs[0] = null;
            }
        }
        catch (InstantiationException instantiationException) {
            this.reporter.errorReport(CREATE_MSG, (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.reporter.errorReport(ACCESS_MSG, (Exception)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.reporter.errorReport(COPY_CON_MSG + string2, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.reporter.errorReport(EXCEPT_CON_MSG + string2, (Exception)invocationTargetException);
        }
        return vRMLNodeType2;
    }

    public static VRMLNodeFactory createFactory(String string) {
        VRMLNodeFactory vRMLNodeFactory = (VRMLNodeFactory)factoryInstances.get(string);
        if (vRMLNodeFactory == null) {
            vRMLNodeFactory = new DefaultNodeFactory(string);
            factoryInstances.put(string, vRMLNodeFactory);
        }
        return vRMLNodeFactory;
    }

    public static VRMLNodeFactory newInstance(String string) {
        return new DefaultNodeFactory(string);
    }

    public static void clearCachedInfo() {
        componentDefsLoaded = false;
        loadedComponents.clear();
        loadedProfiles.clear();
        nodeClassMap.clear();
        constructorMap.clear();
    }

    private Class findNode(String string) {
        Class<?> clazz;
        block3: {
            clazz = null;
            try {
                ComponentInfo componentInfo = (ComponentInfo)nodeNameComponentMap.get(string);
                if (componentInfo == null) break block3;
                StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
                stringBuffer.append('.');
                stringBuffer.append(this.namePrefix);
                stringBuffer.append(string);
                String string2 = stringBuffer.toString();
                clazz = (Class<?>)nodeClassMap.get(string2);
                if (clazz == null) {
                    clazz = Class.forName(string2);
                    nodeClassMap.put(string2, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return clazz;
    }

    private Integer loadComponent(String string) throws UnsupportedComponentException {
        final String string2 = (String)componentFileMap.get(string);
        if (string2 == null) {
            throw new UnsupportedComponentException(string);
        }
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemResourceAsStream(string2);
            }
        });
        if (inputStream == null) {
            throw new UnsupportedComponentException(NO_COMP_FILE_MSG + string);
        }
        Integer n = null;
        try {
            String string3;
            this.properties.clear();
            this.properties.load(inputStream);
            inputStream.close();
            String string4 = this.properties.getProperty("title");
            String string5 = this.properties.getProperty("level");
            String string6 = this.properties.getProperty("url");
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            Enumeration<?> enumeration = this.properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (!string7.endsWith(".package")) continue;
                string3 = this.properties.getProperty(string7);
                String string8 = string7.substring(0, string7.length() - 8);
                hashMap.put(string8, string3);
            }
            int n2 = 1;
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n = new Integer(n2);
            componentLevels.put(string, n);
            string3 = new ComponentInfo(string, n2, string4, string6, hashMap);
            loadedComponents.put(string, string3);
            int n3 = 1;
            while (n3 <= n2) {
                String string9 = this.properties.getProperty("nodes.level." + n3);
                Integer n4 = new Integer(n3);
                if (string9 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string9);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string10 = stringTokenizer.nextToken();
                        nodeNameComponentMap.put(string10, string3);
                        nodeNameLevelMap.put(string10, n4);
                    }
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new UnsupportedComponentException(string + iOException.getMessage());
        }
        return n;
    }

    private ProfileInfo loadProfile(String string) throws UnsupportedProfileException {
        ProfileInfo profileInfo = null;
        final String string2 = string.toLowerCase() + ".properties";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemResourceAsStream(string2);
            }
        });
        if (inputStream == null) {
            throw new UnsupportedComponentException(NO_PROF_FILE_MSG + string);
        }
        try {
            ComponentInfo[] componentInfoArray;
            Properties properties = new Properties();
            properties.clear();
            properties.load(inputStream);
            inputStream.close();
            String string3 = properties.getProperty("title");
            int n = 0;
            ArrayList<ComponentInfo> arrayList = new ArrayList<ComponentInfo>();
            while ((componentInfoArray = properties.getProperty("component." + n)) != null) {
                Object object;
                ++n;
                int n2 = componentInfoArray.indexOf(58);
                Object object2 = componentInfoArray;
                int n3 = -1;
                if (n2 != -1) {
                    object2 = componentInfoArray.substring(0, n2);
                    object = componentInfoArray.substring(n2 + 1);
                    try {
                        n3 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Bad profile component def");
                    }
                }
                if ((object = (ComponentInfo)loadedComponents.get(object2)) == null) {
                    this.loadComponent((String)object2);
                    object = (ComponentInfo)loadedComponents.get(object2);
                }
                if (n3 != -1 && object.getLevel() != n3) {
                    object = new ComponentInfo(object, n3);
                }
                arrayList.add((ComponentInfo)object);
            }
            componentInfoArray = new ComponentInfo[arrayList.size()];
            arrayList.toArray(componentInfoArray);
            profileInfo = new ProfileInfo(string, string3, componentInfoArray);
            loadedProfiles.put(string, profileInfo);
        }
        catch (IOException iOException) {
            throw new UnsupportedProfileException(string + iOException.getMessage());
        }
        return profileInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NODE_CLASS = new Class[]{class$org$web3d$vrml$nodes$VRMLNodeType == null ? (class$org$web3d$vrml$nodes$VRMLNodeType = DefaultNodeFactory.class$("org.web3d.vrml.nodes.VRMLNodeType")) : class$org$web3d$vrml$nodes$VRMLNodeType};
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemResourceAsStream(DefaultNodeFactory.PROPERTY_FILE);
            }
        });
        factoryInstances = new HashMap();
        availableProfiles = new HashSet();
        rendererPrefixMap = new HashMap();
        rendererPackageMap = new HashMap();
        componentFileMap = new HashMap();
        componentLevels = new HashMap();
        nodeNameComponentMap = new HashMap();
        nodeNameLevelMap = new HashMap();
        if (inputStream != null) {
            StringTokenizer stringTokenizer;
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error reading xj3d.properties");
            }
            String string = properties.getProperty("xj3d.profiles");
            if (string != null) {
                stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    availableProfiles.add((Object)string);
                }
            }
            stringTokenizer = properties.propertyNames();
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (!string.startsWith("component.")) continue;
                String string2 = string.substring(10);
                string2 = string2.substring(0, string2.length() - 5);
                String string3 = properties.getProperty(string);
                componentFileMap.put(string2, string3);
            }
            String string4 = properties.getProperty("xj3d.renderer.list");
            if (string4 != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4);
                while (stringTokenizer2.hasMoreTokens()) {
                    string = stringTokenizer2.nextToken();
                    String string5 = properties.getProperty("xj3d.renderer." + string + ".prefix");
                    rendererPrefixMap.put(string, string5);
                    string5 = properties.getProperty("xj3d.renderer." + string + ".package");
                    rendererPackageMap.put(string, string5);
                }
            }
        }
        SUPPORTED_PROFILES = new String[availableProfiles.size()];
        availableProfiles.toArray((Object[])SUPPORTED_PROFILES);
        componentDefsLoaded = false;
        loadedComponents = new HashMap();
        loadedProfiles = new HashMap();
        nodeClassMap = new HashMap();
        constructorMap = new HashMap();
    }
}

