/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.Map;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.SceneGraphTraversalObserver;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLGeometricPropertyNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.CRProtoScene;

public class ProtoCopier
implements SceneGraphTraversalObserver {
    private VRMLNodeFactory factory;
    private CRProtoScene scene;
    private FrameStateManager stateManager;
    private Map nodeMap;
    private CRProtoInstance protoInstance;
    private String worldURL;
    private String version;
    private boolean staticNodes;

    public ProtoCopier(VRMLNodeFactory vRMLNodeFactory, String string) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("No node factory supplied");
        }
        this.factory = vRMLNodeFactory;
        this.worldURL = string;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    void copyNode(CRProtoInstance cRProtoInstance, CRProtoScene cRProtoScene, Map map, String string, boolean bl) {
        if (cRProtoScene == null) {
            throw new NullPointerException("No scene supplied");
        }
        this.scene = cRProtoScene;
        this.protoInstance = cRProtoInstance;
        this.nodeMap = map;
        this.version = string;
        this.staticNodes = bl;
    }

    public void groupingNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLGroupingNodeType vRMLGroupingNodeType2, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType2);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLGroupingNodeType2, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.scene.addNode((VRMLNode)vRMLNodeType);
            this.nodeMap.put(vRMLGroupingNodeType2, vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void inlineNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInlineNodeType vRMLInlineNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLInlineNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLInlineNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            ((VRMLExternalNodeType)vRMLNodeType).setWorldUrl(this.worldURL);
            this.nodeMap.put(vRMLInlineNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void lightNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLLightNodeType vRMLLightNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLLightNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLLightNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLLightNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void bindableNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLBindableNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLBindableNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLBindableNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void shapeNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLShapeNodeType vRMLShapeNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLShapeNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLShapeNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLShapeNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void appearanceNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLAppearanceNodeType vRMLAppearanceNodeType, boolean bl) {
        VRMLAppearanceNodeType vRMLAppearanceNodeType2;
        if (bl) {
            vRMLAppearanceNodeType2 = (VRMLAppearanceNodeType)this.nodeMap.get(vRMLAppearanceNodeType);
            if (!vRMLAppearanceNodeType2.isDEF()) {
                vRMLAppearanceNodeType2.setDEF();
            }
        } else {
            vRMLAppearanceNodeType2 = (VRMLAppearanceNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLAppearanceNodeType, this.version, this.staticNodes);
            vRMLAppearanceNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLAppearanceNodeType, vRMLAppearanceNodeType2);
            this.scene.addNode((VRMLNode)vRMLAppearanceNodeType2);
        }
        if (vRMLShapeNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLAppearanceNodeType2);
        } else {
            VRMLShapeNodeType vRMLShapeNodeType2 = (VRMLShapeNodeType)this.nodeMap.get(vRMLShapeNodeType);
            try {
                vRMLShapeNodeType2.setAppearance((VRMLNodeType)vRMLAppearanceNodeType2);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                System.out.println(invalidFieldValueException.getMessage());
            }
        }
    }

    public void geometricPropertyNode(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType, VRMLGeometricPropertyNodeType vRMLGeometricPropertyNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLGeometricPropertyNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLGeometricPropertyNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLGeometricPropertyNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLComponentGeometryNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType2 = (VRMLComponentGeometryNodeType)this.nodeMap.get(vRMLComponentGeometryNodeType);
            try {
                vRMLComponentGeometryNodeType2.setComponent(vRMLNodeType);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                invalidFieldValueException.printStackTrace();
            }
        }
    }

    public void materialNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLMaterialNodeType vRMLMaterialNodeType, boolean bl) {
        VRMLMaterialNodeType vRMLMaterialNodeType2;
        if (bl) {
            vRMLMaterialNodeType2 = (VRMLMaterialNodeType)this.nodeMap.get(vRMLMaterialNodeType);
            if (!vRMLMaterialNodeType2.isDEF()) {
                vRMLMaterialNodeType2.setDEF();
            }
        } else {
            vRMLMaterialNodeType2 = (VRMLMaterialNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLMaterialNodeType, this.version, this.staticNodes);
            vRMLMaterialNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLMaterialNodeType, vRMLMaterialNodeType2);
            this.scene.addNode((VRMLNode)vRMLMaterialNodeType2);
        }
        if (vRMLAppearanceNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLMaterialNodeType2);
        } else {
            VRMLAppearanceNodeType vRMLAppearanceNodeType2 = (VRMLAppearanceNodeType)this.nodeMap.get(vRMLAppearanceNodeType);
            try {
                vRMLAppearanceNodeType2.setMaterial((VRMLNodeType)vRMLMaterialNodeType2);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                System.out.println(invalidFieldValueException.getMessage());
            }
        }
    }

    public void textureNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureNodeType vRMLTextureNodeType, boolean bl) {
        Object object;
        VRMLTextureNodeType vRMLTextureNodeType2;
        if (bl) {
            vRMLTextureNodeType2 = (VRMLTextureNodeType)this.nodeMap.get(vRMLTextureNodeType);
            if (!vRMLTextureNodeType2.isDEF()) {
                vRMLTextureNodeType2.setDEF();
            }
        } else {
            vRMLTextureNodeType2 = (VRMLTextureNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLTextureNodeType, this.version, this.staticNodes);
            vRMLTextureNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLTextureNodeType, vRMLTextureNodeType2);
            this.scene.addNode((VRMLNode)vRMLTextureNodeType2);
            object = vRMLTextureNodeType.getSecondaryType();
            int n = 0;
            while (n < ((VRMLAppearanceNodeType)object).length) {
                switch (object[n]) {
                    case 16: 
                    case 30: 
                    case 44: {
                        ((VRMLExternalNodeType)vRMLTextureNodeType2).setWorldUrl(this.worldURL);
                        break;
                    }
                }
                ++n;
            }
        }
        if (vRMLAppearanceNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLTextureNodeType2);
        } else {
            object = (VRMLAppearanceNodeType)this.nodeMap.get(vRMLAppearanceNodeType);
            try {
                object.setTexture((VRMLNodeType)vRMLTextureNodeType2);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                System.out.println(invalidFieldValueException.getMessage());
            }
        }
    }

    public void textureTransformNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureTransformNodeType vRMLTextureTransformNodeType, boolean bl) {
        VRMLTextureTransformNodeType vRMLTextureTransformNodeType2;
        if (bl) {
            vRMLTextureTransformNodeType2 = (VRMLTextureTransformNodeType)this.nodeMap.get(vRMLTextureTransformNodeType);
            if (!vRMLTextureTransformNodeType2.isDEF()) {
                vRMLTextureTransformNodeType2.setDEF();
            }
        } else {
            vRMLTextureTransformNodeType2 = (VRMLTextureTransformNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLTextureTransformNodeType, this.version, this.staticNodes);
            vRMLTextureTransformNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLTextureTransformNodeType, vRMLTextureTransformNodeType2);
            this.scene.addNode((VRMLNode)vRMLTextureTransformNodeType2);
        }
        if (vRMLAppearanceNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLTextureTransformNodeType2);
        } else {
            VRMLAppearanceNodeType vRMLAppearanceNodeType2 = (VRMLAppearanceNodeType)this.nodeMap.get(vRMLAppearanceNodeType);
            try {
                vRMLAppearanceNodeType2.setTextureTransform((VRMLNodeType)vRMLTextureTransformNodeType2);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                System.out.println(invalidFieldValueException.getMessage());
            }
        }
    }

    public void geometryNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLGeometryNodeType vRMLGeometryNodeType, boolean bl) {
        VRMLGeometryNodeType vRMLGeometryNodeType2;
        if (bl) {
            vRMLGeometryNodeType2 = (VRMLGeometryNodeType)this.nodeMap.get(vRMLGeometryNodeType);
            if (!vRMLGeometryNodeType2.isDEF()) {
                vRMLGeometryNodeType2.setDEF();
            }
        } else {
            vRMLGeometryNodeType2 = (VRMLGeometryNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLGeometryNodeType, this.version, this.staticNodes);
            vRMLGeometryNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLGeometryNodeType, vRMLGeometryNodeType2);
            this.scene.addNode((VRMLNode)vRMLGeometryNodeType2);
        }
        if (vRMLShapeNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLGeometryNodeType2);
        } else {
            VRMLShapeNodeType vRMLShapeNodeType2 = (VRMLShapeNodeType)this.nodeMap.get(vRMLShapeNodeType);
            try {
                vRMLShapeNodeType2.setGeometry((VRMLNodeType)vRMLGeometryNodeType2);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                System.out.println(invalidFieldValueException.getMessage());
            }
        }
    }

    public void soundNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSoundNodeType vRMLSoundNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLSoundNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLSoundNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLSoundNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void audioClipNode(VRMLSoundNodeType vRMLSoundNodeType, VRMLAudioClipNodeType vRMLAudioClipNodeType, boolean bl) {
        VRMLAudioClipNodeType vRMLAudioClipNodeType2;
        if (bl) {
            vRMLAudioClipNodeType2 = (VRMLAudioClipNodeType)this.nodeMap.get(vRMLAudioClipNodeType);
            if (!vRMLAudioClipNodeType2.isDEF()) {
                vRMLAudioClipNodeType2.setDEF();
            }
        } else {
            vRMLAudioClipNodeType2 = (VRMLAudioClipNodeType)this.factory.createVRMLNode((VRMLNodeType)vRMLAudioClipNodeType, this.version, this.staticNodes);
            vRMLAudioClipNodeType2.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLAudioClipNodeType, vRMLAudioClipNodeType2);
            this.scene.addNode((VRMLNode)vRMLAudioClipNodeType2);
        }
        if (vRMLSoundNodeType == null) {
            this.protoInstance.addBodyChild((VRMLNodeType)vRMLAudioClipNodeType2);
        } else {
            VRMLSoundNodeType vRMLSoundNodeType2 = (VRMLSoundNodeType)this.nodeMap.get(vRMLSoundNodeType);
            vRMLSoundNodeType2.setSource(vRMLAudioClipNodeType2);
        }
    }

    public void interpolatorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInterpolatorNodeType vRMLInterpolatorNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLInterpolatorNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLInterpolatorNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLInterpolatorNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void sensorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSensorNodeType vRMLSensorNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLSensorNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLSensorNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            this.scene.addNode((VRMLNode)vRMLNodeType);
            this.nodeMap.put(vRMLSensorNodeType, vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void scriptNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLScriptNodeType vRMLScriptNodeType, boolean bl) {
        VRMLNodeType vRMLNodeType;
        if (bl) {
            vRMLNodeType = (VRMLNodeType)this.nodeMap.get(vRMLScriptNodeType);
            if (!vRMLNodeType.isDEF()) {
                vRMLNodeType.setDEF();
            }
        } else {
            vRMLNodeType = this.factory.createVRMLNode((VRMLNodeType)vRMLScriptNodeType, this.version, this.staticNodes);
            vRMLNodeType.setFrameStateManager(this.stateManager);
            ((VRMLExternalNodeType)vRMLNodeType).setWorldUrl(this.worldURL);
            this.nodeMap.put(vRMLScriptNodeType, vRMLNodeType);
            this.scene.addNode((VRMLNode)vRMLNodeType);
        }
        if (vRMLGroupingNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType);
        } else {
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLGroupingNodeType);
            int n = vRMLNodeType2.getFieldIndex("children");
            try {
                vRMLNodeType2.setValue(n, vRMLNodeType);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void protoNode(VRMLNodeType vRMLNodeType, VRMLProtoInstance vRMLProtoInstance, boolean bl) {
        throw new RuntimeException("ProtoCopier protoNode Should not be used");
    }

    public void protoNode(VRMLNodeType vRMLNodeType, CRProtoInstance cRProtoInstance) {
        if (vRMLNodeType == null) {
            this.protoInstance.addBodyChild(cRProtoInstance);
            return;
        }
        this.scene.addNode((VRMLNode)cRProtoInstance);
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
        int n = vRMLNodeType.getPrimaryType();
        int n2 = cRProtoInstance.getImplementationNode().getPrimaryType();
        switch (n) {
            case 22: {
                ((VRMLGroupingNodeType)vRMLNodeType2).addChild((VRMLNodeType)cRProtoInstance);
                break;
            }
            case 43: {
                int n3 = n2 == 2 ? vRMLNodeType2.getFieldIndex("appearance") : vRMLNodeType2.getFieldIndex("geometry");
                try {
                    ((VRMLShapeNodeType)vRMLNodeType2).setValue(n3, (VRMLNodeType)cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 2: {
                int n4;
                switch (n2) {
                    case 29: {
                        n4 = vRMLNodeType2.getFieldIndex("material");
                        break;
                    }
                    case 50: {
                        n4 = vRMLNodeType2.getFieldIndex("texture");
                        break;
                    }
                    case 51: {
                        n4 = vRMLNodeType2.getFieldIndex("textureTransform");
                        break;
                    }
                    default: {
                        n4 = -1;
                    }
                }
                try {
                    ((VRMLAppearanceNodeType)vRMLNodeType2).setValue(n4, (VRMLNodeType)cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 45: {
                int n5 = vRMLNodeType2.getFieldIndex("source");
                try {
                    ((VRMLSoundNodeType)vRMLNodeType2).setValue(n5, (VRMLNodeType)cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 3: 
            case 5: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 42: 
            case 50: 
            case 51: {
                break;
            }
            case 41: {
                System.out.println("Proto creator can't handle script fields containing protos. Must fix");
            }
        }
    }

    public void customNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        VRMLNodeType vRMLNodeType3;
        if (bl) {
            vRMLNodeType3 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType2);
            if (!vRMLNodeType3.isDEF()) {
                vRMLNodeType3.setDEF();
            }
        } else {
            vRMLNodeType3 = this.factory.createVRMLNode(vRMLNodeType2, this.version, this.staticNodes);
            vRMLNodeType3.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
        }
        if (vRMLNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType3);
        } else {
            VRMLNodeType vRMLNodeType4 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
            try {
                vRMLNodeType4.setValue(n, vRMLNodeType3);
            }
            catch (FieldException fieldException) {}
        }
    }

    public void miscellaneousNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        VRMLNodeType vRMLNodeType3;
        if (bl) {
            vRMLNodeType3 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType2);
            if (!vRMLNodeType3.isDEF()) {
                vRMLNodeType3.setDEF();
            }
        } else {
            vRMLNodeType3 = this.factory.createVRMLNode(vRMLNodeType2, this.version, this.staticNodes);
            vRMLNodeType3.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
        }
        if (vRMLNodeType == null) {
            this.protoInstance.addBodyChild(vRMLNodeType3);
        } else {
            VRMLNodeType vRMLNodeType4 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
            try {
                vRMLNodeType4.setValue(n, vRMLNodeType3);
            }
            catch (FieldException fieldException) {}
        }
    }
}

