/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.ietf.uri.ResourceConnection;
import org.web3d.util.BlockingQueue;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;

abstract class AbstractContentLoader
implements Runnable {
    protected BlockingQueue pendingList;
    protected Map inProgress;
    protected boolean terminateCurrent;
    protected boolean processNext;
    protected ResourceConnection currentConnection;
    protected ErrorReporter errorReporter;

    AbstractContentLoader(ThreadGroup threadGroup, BlockingQueue blockingQueue, Map map) {
        this.pendingList = blockingQueue;
        this.inProgress = map;
        this.terminateCurrent = false;
        this.processNext = true;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null && !this.terminateCurrent && this.processNext) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    void abortCurrentFile() {
        this.terminateCurrent = true;
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    void shutdown() {
        this.terminateCurrent = true;
        this.processNext = false;
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    protected boolean makeConnection() {
        boolean bl = true;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    AbstractContentLoader.this.currentConnection.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = "IO Error reading external file " + this.currentConnection.getURI();
            bl = false;
            this.errorReporter.warningReport(string, privilegedActionException.getException());
        }
        return bl;
    }
}

