/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.web3d.util.ErrorReporter;
import org.web3d.util.Queue;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.loader.AbstractContentLoader;
import org.web3d.vrml.nodes.loader.ContentLoader;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadConstants;
import org.web3d.vrml.nodes.loader.LoadDetails;
import org.web3d.vrml.nodes.loader.LoaderThreadPool;
import org.web3d.vrml.util.NodeArray;

public abstract class AbstractLoadManager
implements ExternalLoadManager,
LoadConstants,
VRMLUrlListener {
    private LoaderThreadPool loaderPool = LoaderThreadPool.getLoaderThreadPool();
    private Queue pending = this.loaderPool.getWaitingList();
    private Map inProgress = this.loaderPool.getProgressMap();

    protected AbstractLoadManager() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public void queueSceneLoad(BasicScene basicScene) {
        LoadDetails loadDetails;
        Iterator<Object> iterator;
        Object object;
        if (basicScene == null) {
            return;
        }
        this.ayeShesDeadCapn();
        FileCache fileCache = this.getCache();
        if (basicScene instanceof VRMLScene) {
            object = ((VRMLScene)basicScene).getExternProtos();
            Collection collection = object.values();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = -1;
                loadDetails.node = (VRMLExternalNodeType)iterator.next();
                loadDetails.cache = fileCache;
                this.pending.add((Object)loadDetails);
            }
        }
        object = basicScene.getBySecondaryType(44);
        int n = ((ArrayList)object).size();
        int n2 = 0;
        while (n2 < n) {
            iterator = ((ArrayList)object).get(n2);
            if (!(iterator instanceof VRMLScriptNodeType)) {
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = -1;
                loadDetails.node = (VRMLExternalNodeType)iterator;
                loadDetails.cache = fileCache;
                this.pending.add((Object)loadDetails);
                ((VRMLExternalNodeType)iterator).addUrlListener((VRMLUrlListener)this);
            }
            ++n2;
        }
        object = basicScene.getBySecondaryType(30);
        n = ((ArrayList)object).size();
        n2 = 0;
        while (n2 < n) {
            VRMLMultiExternalNodeType vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)((ArrayList)object).get(n2);
            int[] nArray = vRMLMultiExternalNodeType.getUrlFieldIndexes();
            int n3 = 0;
            while (n3 < nArray.length) {
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = nArray[n3];
                loadDetails.node = vRMLMultiExternalNodeType;
                loadDetails.cache = fileCache;
                this.pending.add((Object)loadDetails);
                ++n3;
            }
            vRMLMultiExternalNodeType.addUrlListener((VRMLUrlListener)this);
            ++n2;
        }
    }

    public void queueNodesLoad(NodeArray nodeArray) {
        FileCache fileCache = this.getCache();
        int n = nodeArray.size();
        this.ayeShesDeadCapn();
        int n2 = 0;
        while (n2 < n) {
            VRMLNodeType vRMLNodeType = nodeArray.get(n2);
            if (!(vRMLNodeType instanceof VRMLScriptNodeType)) {
                LoadDetails loadDetails;
                VRMLExternalNodeType vRMLExternalNodeType;
                if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
                    vRMLExternalNodeType = (VRMLExternalNodeType)vRMLNodeType;
                    loadDetails = new LoadDetails();
                    loadDetails.fieldIndex = -1;
                    loadDetails.node = vRMLExternalNodeType;
                    loadDetails.cache = fileCache;
                    this.pending.add((Object)loadDetails);
                    vRMLExternalNodeType.addUrlListener((VRMLUrlListener)this);
                } else if (vRMLNodeType instanceof VRMLMultiExternalNodeType) {
                    vRMLExternalNodeType = (VRMLMultiExternalNodeType)nodeArray.get(n2);
                    int[] nArray = vRMLExternalNodeType.getUrlFieldIndexes();
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        loadDetails = new LoadDetails();
                        loadDetails.fieldIndex = nArray[n3];
                        loadDetails.node = vRMLExternalNodeType;
                        loadDetails.cache = fileCache;
                        this.pending.add((Object)loadDetails);
                        ++n3;
                    }
                    vRMLExternalNodeType.addUrlListener((VRMLUrlListener)this);
                }
            }
            ++n2;
        }
    }

    public void stopSceneLoad(BasicScene basicScene) {
        Object object;
        if (basicScene == null) {
            return;
        }
        ArrayList arrayList = basicScene.getBySecondaryType(44);
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Object e = arrayList.get(n2);
            this.pending.remove(e);
            if (this.inProgress.containsKey(e)) {
                object = (ContentLoader)this.inProgress.get(e);
                ((AbstractContentLoader)object).abortCurrentFile();
            }
            ++n2;
        }
        arrayList = basicScene.getBySecondaryType(30);
        n = arrayList.size();
        if (n == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            object = arrayList.get(n3);
            this.pending.remove(object);
            if (this.inProgress.containsKey(object)) {
                ContentLoader contentLoader = (ContentLoader)this.inProgress.get(object);
                contentLoader.abortCurrentFile();
            }
            ++n3;
        }
    }

    public void clear() {
        this.pending.clear();
        Set set = this.inProgress.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ContentLoader contentLoader = (ContentLoader)entry.getValue();
            contentLoader.abortCurrentFile();
        }
    }

    public void urlChanged(VRMLNodeType vRMLNodeType, int n) {
        LoadDetails loadDetails = new LoadDetails();
        if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
            loadDetails.fieldIndex = -1;
            ((VRMLSingleExternalNodeType)vRMLNodeType).setLoadState(1);
        } else {
            loadDetails.fieldIndex = n;
            ((VRMLMultiExternalNodeType)vRMLNodeType).setLoadState(n, 1);
        }
        loadDetails.node = (VRMLExternalNodeType)vRMLNodeType;
        loadDetails.cache = this.getCache();
        this.pending.add((Object)loadDetails);
    }

    protected abstract FileCache getCache();

    private void ayeShesDeadCapn() {
        this.loaderPool.restartThreads();
    }
}

