/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.util.Queue;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.ScriptLoadDetails;
import org.web3d.vrml.nodes.loader.ScriptLoadStatusListener;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.ScriptThreadPool;
import org.web3d.vrml.nodes.loader.WeakRefFileCache;
import org.web3d.vrml.scripting.ScriptEngine;

public class DefaultScriptLoader
implements ScriptLoader {
    private static FileCache cache = new WeakRefFileCache();
    private ScriptThreadPool loaderPool;
    private Queue pending;
    private Map inProgress;
    private HashMap engineMap = new HashMap();
    private ScriptLoadStatusListener statusListener;

    public DefaultScriptLoader() {
        this.loaderPool = ScriptThreadPool.getScriptThreadPool();
        this.pending = this.loaderPool.getWaitingList();
        this.inProgress = this.loaderPool.getProgressMap();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public void registerScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = 0;
        while (n < stringArray.length) {
            this.engineMap.put(stringArray[n], scriptEngine);
            ++n;
        }
    }

    public void UnregisterScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = 0;
        while (n < stringArray.length) {
            Object v = this.engineMap.get(stringArray[n]);
            if (v == scriptEngine) {
                this.engineMap.remove(stringArray[n]);
            }
            ++n;
        }
    }

    public void setStatusListener(ScriptLoadStatusListener scriptLoadStatusListener) {
        this.statusListener = scriptLoadStatusListener;
    }

    public void loadScript(VRMLScriptNodeType vRMLScriptNodeType) {
        if (vRMLScriptNodeType.getLoadState() != 1) {
            return;
        }
        String[] stringArray = vRMLScriptNodeType.getUrl();
        if (stringArray == null || stringArray.length == 0) {
            vRMLScriptNodeType.setLoadState(3);
            this.statusListener.loadCompleted(vRMLScriptNodeType);
        } else {
            this.loaderPool.restartThreads();
            ScriptLoadDetails scriptLoadDetails = new ScriptLoadDetails();
            scriptLoadDetails.fieldIndex = -1;
            scriptLoadDetails.node = vRMLScriptNodeType;
            scriptLoadDetails.cache = cache;
            scriptLoadDetails.engineMap = this.engineMap;
            scriptLoadDetails.statusListener = this.statusListener;
            this.pending.add((Object)scriptLoadDetails);
        }
    }
}

