/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.IOException;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.SceneBuilder;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLReader;

class DefaultWorldLoader
implements WorldLoader {
    private static IntHashMap builderFactoryMap = new IntHashMap();
    private static IntHashMap builderInstanceMap = new IntHashMap();
    private static IntHashMap parserFactoryMap = new IntHashMap();
    private ErrorReporter errorReporter;
    private FrameStateManager stateManager;

    DefaultWorldLoader(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public VRMLScene loadNow(BrowserCore browserCore, InputSource inputSource) throws IOException {
        return this.loadNow(browserCore, inputSource, false);
    }

    public VRMLScene loadNow(BrowserCore browserCore, InputSource inputSource, boolean bl) throws IOException {
        int n = browserCore.getRendererType();
        SceneBuilder sceneBuilder = DefaultWorldLoader.getBuilder(n);
        if (sceneBuilder == null) {
            throw new VRMLException("Unable to find a builder to locate SceneBuilder instance");
        }
        VRMLParserFactory vRMLParserFactory = DefaultWorldLoader.getParserFactory(n);
        if (vRMLParserFactory == null) {
            throw new VRMLException("Unable to find a builder to locate Parser instance");
        }
        sceneBuilder.reset();
        sceneBuilder.setFrameStateManager(this.stateManager);
        VRMLReader vRMLReader = vRMLParserFactory.newVRMLReader();
        vRMLReader.setHeaderIgnore(bl);
        vRMLReader.setContentHandler((ContentHandler)sceneBuilder);
        vRMLReader.setScriptHandler((ScriptHandler)sceneBuilder);
        vRMLReader.setProtoHandler((ProtoHandler)sceneBuilder);
        vRMLReader.setRouteHandler((RouteHandler)sceneBuilder);
        vRMLReader.parse(inputSource);
        VRMLScene vRMLScene = sceneBuilder.getScene();
        DefaultWorldLoader.releaseBuilder(n, sceneBuilder);
        return vRMLScene;
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    static void registerBuilderFactory(int n, SceneBuilderFactory sceneBuilderFactory) {
        if (sceneBuilderFactory == null) {
            builderFactoryMap.remove(n);
        } else {
            builderFactoryMap.put(n, (Object)sceneBuilderFactory);
        }
    }

    static SceneBuilderFactory getBuilderFactory(int n) {
        return (SceneBuilderFactory)builderFactoryMap.get(n);
    }

    static void registerParserFactory(int n, VRMLParserFactory vRMLParserFactory) {
        if (vRMLParserFactory == null) {
            parserFactoryMap.remove(n);
        } else {
            parserFactoryMap.put(n, (Object)vRMLParserFactory);
        }
    }

    static VRMLParserFactory getParserFactory(int n) {
        return (VRMLParserFactory)parserFactoryMap.get(n);
    }

    private static SceneBuilder getBuilder(int n) {
        ObjectArray objectArray = (ObjectArray)builderInstanceMap.get(n);
        SceneBuilder sceneBuilder = null;
        if (objectArray != null && objectArray.size() != 0) {
            sceneBuilder = (SceneBuilder)objectArray.remove(objectArray.size() - 1);
        } else {
            SceneBuilderFactory sceneBuilderFactory = DefaultWorldLoader.getBuilderFactory(n);
            if (sceneBuilderFactory != null) {
                sceneBuilder = sceneBuilderFactory.createBuilder();
            }
        }
        return sceneBuilder;
    }

    private static void releaseBuilder(int n, SceneBuilder sceneBuilder) {
        ObjectArray objectArray = (ObjectArray)builderInstanceMap.get(n);
        if (objectArray == null) {
            objectArray = new ObjectArray();
            builderInstanceMap.put(n, (Object)objectArray);
        }
        objectArray.add((Object)sceneBuilder);
    }
}

