/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Map;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.web3d.util.BlockingQueue;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.loader.AbstractContentLoader;
import org.web3d.vrml.nodes.loader.CacheDetails;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.ScriptLoadDetails;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;

class ScriptContentLoader
extends AbstractContentLoader {
    private Thread th;
    private static final String JAVA_MIME = "application/x-java";

    ScriptContentLoader(ThreadGroup threadGroup, BlockingQueue blockingQueue, Map map) {
        super(threadGroup, blockingQueue, map);
        this.th = new Thread(threadGroup, this);
        this.th.start();
    }

    public void run() {
        VRMLScriptNodeType vRMLScriptNodeType = null;
        boolean bl = false;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        while (this.processNext) {
            Object object;
            if (vRMLScriptNodeType != null) {
                this.inProgress.remove(vRMLScriptNodeType);
            }
            ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)this.pendingList.getNext();
            vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
            boolean bl2 = false;
            if (!this.processNext) break;
            this.terminateCurrent = false;
            this.inProgress.put(vRMLScriptNodeType, this);
            vRMLScriptNodeType.setLoadState(2);
            if (this.terminateCurrent) continue;
            String[] stringArray = vRMLScriptNodeType.getUrl();
            if (this.terminateCurrent) continue;
            int n = 0;
            while (!bl2 && n < stringArray.length) {
                CacheDetails cacheDetails;
                String string = stringArray[n];
                int n2 = string.lastIndexOf(35);
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                if ((cacheDetails = scriptLoadDetails.cache.checkForFile(string)) != null) {
                    String string2 = cacheDetails.getContentType();
                    ScriptEngine scriptEngine = (ScriptEngine)scriptLoadDetails.engineMap.get(string2);
                    if (scriptEngine != null) {
                        object = cacheDetails.getContent();
                        bl2 = true;
                        try {
                            ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string2, object);
                            vRMLScriptNodeType.setContent(string2, (Object)scriptWrapper);
                        }
                        catch (InvalidScriptContentException invalidScriptContentException) {
                            String string3 = "Invalid content for script " + string;
                            this.errorReporter.errorReport(string3, (Exception)((Object)invalidScriptContentException));
                        }
                    }
                } else {
                    bl2 = this.loadExternal(string, scriptLoadDetails.cache, vRMLScriptNodeType, scriptLoadDetails.engineMap);
                }
                ++n;
            }
            this.inProgress.remove(vRMLScriptNodeType);
            if (bl2) {
                vRMLScriptNodeType.setLoadState(3);
                scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
            } else {
                vRMLScriptNodeType.setLoadState(4);
                scriptLoadDetails.statusListener.loadFailed(vRMLScriptNodeType);
                this.errorReporter.errorReport("Could not load any URLs for script", null);
            }
            vRMLScriptNodeType = null;
            this.currentConnection = null;
            stringArray = null;
            object = null;
            Thread.yield();
        }
        this.th = null;
    }

    private boolean loadExternal(String string, FileCache fileCache, VRMLScriptNodeType vRMLScriptNodeType, Map map) {
        boolean bl = false;
        URL[] uRLArray = null;
        if (string.endsWith(".class")) {
            ScriptEngine scriptEngine = (ScriptEngine)map.get(JAVA_MIME);
            if (scriptEngine == null) {
                return false;
            }
            return this.loadClass(string, fileCache, vRMLScriptNodeType, scriptEngine);
        }
        try {
            URI uRI = URIUtils.createURI((String)string);
            if (this.terminateCurrent) {
                return false;
            }
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            String string2 = "URI does not resolve to anything useful.\nURI is " + string;
            this.errorReporter.warningReport(string2, (Exception)iOException);
            return false;
        }
        if (this.terminateCurrent) {
            return false;
        }
        if (uRLArray == null) {
            this.errorReporter.warningReport("Script contains no URLs. Ignoring", null);
            return false;
        }
        int n = 0;
        while (n < uRLArray.length) {
            block21: {
                String string3;
                try {
                    this.currentConnection = uRLArray[n].getResource();
                }
                catch (IOException iOException) {
                    string3 = "Can't find resource " + uRLArray[n];
                    this.errorReporter.warningReport(string3, (Exception)iOException);
                    break block21;
                }
                if (!this.makeConnection()) {
                    if (this.terminateCurrent) {
                        break;
                    }
                } else {
                    if (this.terminateCurrent) break;
                    try {
                        ScriptEngine scriptEngine;
                        if (this.terminateCurrent) {
                            this.currentConnection.close();
                            break;
                        }
                        String string4 = this.currentConnection.getContentType();
                        if (this.terminateCurrent) {
                            this.currentConnection.close();
                            break;
                        }
                        if (string4 != null && (scriptEngine = (ScriptEngine)map.get(string4)) != null) {
                            Object object = this.currentConnection.getContent();
                            if (this.terminateCurrent) break;
                            string3 = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string4, object);
                            if (this.terminateCurrent) break;
                            fileCache.cacheFile(string, string4, object);
                            if (this.terminateCurrent) break;
                            vRMLScriptNodeType.setContent(string4, (Object)string3);
                            bl = true;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        string3 = "IO Error reading external file " + string;
                        this.errorReporter.warningReport(string3, (Exception)iOException);
                        if (this.terminateCurrent) {
                            break;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.errorReporter.warningReport("Can't set external content", (Exception)illegalArgumentException);
                    }
                    catch (InvalidScriptContentException invalidScriptContentException) {
                        String string5 = "Invalid content for script url " + string;
                        this.errorReporter.warningReport(string5, (Exception)((Object)invalidScriptContentException));
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    private boolean loadClass(String string, FileCache fileCache, VRMLScriptNodeType vRMLScriptNodeType, ScriptEngine scriptEngine) {
        String string2;
        String string3;
        boolean bl = true;
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (string.startsWith("jar:")) {
            int n3 = string.lastIndexOf("!");
            string3 = string.substring(4, n3);
            string2 = string.substring(n3 + 2, n2);
        } else {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1, n2);
        }
        String string4 = null;
        Throwable throwable = null;
        try {
            java.net.URL[] uRLArray = new java.net.URL[]{new java.net.URL(string3)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = uRLClassLoader.loadClass(string2);
            ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
            fileCache.cacheFile(string, JAVA_MIME, clazz);
            vRMLScriptNodeType.setContent(JAVA_MIME, (Object)scriptWrapper);
        }
        catch (MalformedURLException malformedURLException) {
            string4 = "Invalid URL for the script " + string3;
            throwable = malformedURLException;
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string4 = "Couldn't find the Java class " + string2 + " at: " + string3;
            throwable = classNotFoundException;
            bl = false;
        }
        catch (InvalidScriptContentException invalidScriptContentException) {
            string4 = "Invalid content for script " + string;
            throwable = invalidScriptContentException;
            bl = false;
        }
        if (string4 != null) {
            this.errorReporter.errorReport(string4, (Exception)throwable);
        }
        return bl;
    }

    protected boolean isAlive() {
        if (this.th == null) {
            return false;
        }
        return this.th.isAlive();
    }
}

