/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPrototype;
import org.web3d.vrml.parser.VRMLFieldReader;

public abstract class AbstractProto
implements VRMLPrototype {
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    protected Map fieldIndexMap;
    protected List fieldDeclList;
    protected String nodeName;
    protected VRMLFieldReader fieldParser;
    protected VRMLFieldData fieldData;
    private int fieldCount;
    private VRMLNodeListener nodeListener;
    protected boolean isVrml97;

    public AbstractProto(String string, boolean bl) {
        this.nodeName = string;
        this.isVrml97 = bl;
        this.fieldIndexMap = new HashMap();
        this.fieldDeclList = new ArrayList();
        this.fieldData = new VRMLFieldData();
        this.fieldCount = 0;
    }

    protected void checkNodeType(VRMLNodeType vRMLNodeType) {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals(this.nodeName)) {
            throw new IllegalArgumentException("The supplied node cannot be copied as it's type is wrong. The type supplied is type");
        }
    }

    public void setName(String string) {
        this.nodeName = string;
    }

    public String getName() {
        return this.nodeName;
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    protected void fireFieldChanged(int n) {
        block2: {
            if (this.nodeListener == null) break block2;
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException, InvalidFieldException {
        Integer n;
        String string = vRMLFieldDeclaration.getName();
        if (this.isVrml97) {
            switch (vRMLFieldDeclaration.getFieldType()) {
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 29: 
                case 30: {
                    throw new InvalidFieldException(VRML97_FIELD_MSG + vRMLFieldDeclaration.getFieldTypeString());
                }
            }
        }
        if ((n = (Integer)this.fieldIndexMap.get(string)) != null) {
            VRMLFieldDeclaration vRMLFieldDeclaration2 = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType() || vRMLFieldDeclaration.getAccessType() != vRMLFieldDeclaration.getAccessType()) {
                throw new FieldExistsException("Can't add here", string);
            }
        }
        this.fieldIndexMap.put(string, new Integer(this.fieldCount));
        this.fieldDeclList.add(vRMLFieldDeclaration);
        int n2 = this.fieldCount++;
        return n2;
    }

    public void deleteField(int n) throws InvalidFieldException, IndexOutOfBoundsException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException();
        }
        this.fieldDeclList.set(n, null);
        this.fieldIndexMap.remove(vRMLFieldDeclaration.getName());
    }

    public void deleteField(VRMLFieldDeclaration vRMLFieldDeclaration) throws InvalidFieldException, IndexOutOfBoundsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.remove(string);
        if (n == null) {
            throw new InvalidFieldException("No field here", string);
        }
        this.fieldDeclList.set(n, null);
    }

    public List getAllFields() {
        ArrayList arrayList = new ArrayList();
        int n = this.fieldDeclList.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.fieldDeclList.get(n2);
            if (e != null) {
                arrayList.add(e);
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean isVRML97() {
        return this.isVrml97;
    }

    public int getFieldIndex(String string) {
        int n = -1;
        Integer n2 = (Integer)this.fieldIndexMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return (VRMLFieldDeclaration)this.fieldDeclList.get(n);
    }
}

