/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLPrototype;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.DefaultLocator;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoInstancePlaceHolder;
import org.web3d.vrml.nodes.proto.ProtoROUTE;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;

public class ProtoBuilder
implements ContentHandler,
ProtoHandler,
ScriptHandler,
RouteHandler {
    private static final int STACK_START_SIZE = 50;
    private static final int STACK_INCREMENT = 25;
    private static final String VRML97_PROFILE_STRING = "vrml97";
    private boolean init;
    private ErrorHandler errorHandler;
    private Locator locator;
    private boolean inScript = false;
    private boolean inProtoDecl = false;
    private boolean inProtoBody = false;
    private boolean inExternProtoDecl = false;
    private boolean inExternProtoURI = false;
    private int ignoreNodeCounter;
    private int currentFieldIndex;
    private VRMLNodeType currentNode;
    private AbstractProto currentProto;
    private VRMLScriptNodeType currentScript;
    private AbstractProto rootProto;
    private VRMLNodeType[] nodeStack;
    private int[] childIndexStack;
    private int topOfStack;
    private Map globalDefMap;
    private Map globalProtoMap;
    private Map globalExternProtoMap;
    private HashMap defMap;
    private HashMap protoMap;
    private HashMap externProtoMap;
    private SimpleStack protoDeclStack;
    private SimpleStack scriptStack;
    private SimpleStack defMapStack;
    private SimpleStack protoMapStack;
    private VRMLNodeFactory nodeFactory;
    private boolean isVrml97;
    private HashSet dontLoadTypes;
    private HashSet ignoreDefSet;
    private String worldURL;
    private String version;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLBackgroundNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLFogNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLLightNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLAudioClipNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLViewpointNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLInlineNodeType;

    public ProtoBuilder(VRMLNodeFactory vRMLNodeFactory) throws NullPointerException {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("The factory is null");
        }
        this.nodeFactory = vRMLNodeFactory;
        this.defMap = new HashMap();
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.protoDeclStack = new SimpleStack();
        this.scriptStack = new SimpleStack();
        this.defMapStack = new SimpleStack();
        this.protoMapStack = new SimpleStack();
        this.dontLoadTypes = new HashSet();
        this.ignoreDefSet = new HashSet();
        this.nodeStack = new VRMLNodeType[50];
        this.childIndexStack = new int[50];
    }

    public AbstractProto getPrototype() {
        return this.rootProto;
    }

    public void reset() {
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        this.worldURL = null;
        this.dontLoadTypes.clear();
        this.ignoreDefSet.clear();
        this.defMap.clear();
        this.protoMap.clear();
        this.externProtoMap.clear();
        this.protoDeclStack.clear();
        this.defMapStack.clear();
        this.protoMapStack.clear();
    }

    public void setGlobals(Map map, Map map2, Map map3) {
        this.globalDefMap = map == null ? new HashMap() : map;
        this.globalProtoMap = map2 == null ? new HashMap() : map2;
        this.globalExternProtoMap = map3 == null ? new HashMap() : map3;
        this.init = true;
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.isVrml97 = bl;
        if (!bl2) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLBackgroundNodeType == null ? (class$org$web3d$vrml$nodes$VRMLBackgroundNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLBackgroundNodeType")) : class$org$web3d$vrml$nodes$VRMLBackgroundNodeType));
        }
        if (!bl3) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLFogNodeType == null ? (class$org$web3d$vrml$nodes$VRMLFogNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLFogNodeType")) : class$org$web3d$vrml$nodes$VRMLFogNodeType));
        }
        if (!bl4) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLLightNodeType == null ? (class$org$web3d$vrml$nodes$VRMLLightNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLLightNodeType")) : class$org$web3d$vrml$nodes$VRMLLightNodeType));
        }
        if (!bl5) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLAudioClipNodeType == null ? (class$org$web3d$vrml$nodes$VRMLAudioClipNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLAudioClipNodeType")) : class$org$web3d$vrml$nodes$VRMLAudioClipNodeType));
        }
        if (!bl6) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLViewpointNodeType == null ? (class$org$web3d$vrml$nodes$VRMLViewpointNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLViewpointNodeType")) : class$org$web3d$vrml$nodes$VRMLViewpointNodeType));
        }
        if (!bl7) {
            this.dontLoadTypes.add((Object)(class$org$web3d$vrml$nodes$VRMLInlineNodeType == null ? (class$org$web3d$vrml$nodes$VRMLInlineNodeType = ProtoBuilder.class$("org.web3d.vrml.nodes.VRMLInlineNodeType")) : class$org$web3d$vrml$nodes$VRMLInlineNodeType));
        }
    }

    public void newProto() {
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5) throws SAVException, VRMLException {
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.worldURL = string;
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        this.version = string4.substring(1);
        if (string3.charAt(1) == 'V') {
            this.nodeFactory.setProfile(VRML97_PROFILE_STRING);
        }
        if (this.locator == null) {
            this.locator = new DefaultLocator();
        }
        if (!this.init) {
            this.globalDefMap = new HashMap();
            this.globalProtoMap = new HashMap();
            this.globalExternProtoMap = new HashMap();
            this.init = true;
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.nodeFactory.setProfile(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        Object object;
        int n = string.indexOf(58);
        String string2 = string;
        int n2 = -1;
        if (n != -1) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Component level is malformed");
            }
        }
        object = this.nodeFactory.addComponent(string2, n2);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        System.out.println("IMPORTs in PROTO not implmented yet");
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        throw new SAVException("Protos cannot contain EXPORT statements");
    }

    public void endDocument() throws SAVException, VRMLException {
        int n = 0;
        while (n < this.topOfStack) {
            this.nodeStack[n] = null;
            ++n;
        }
        this.topOfStack = 0;
        this.currentNode = null;
        this.currentProto = null;
        this.currentScript = null;
        this.currentFieldIndex = -1;
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Node declaration in externproto decl");
        }
        if (this.ignoreNodeCounter > 0) {
            ++this.ignoreNodeCounter;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add((Object)string2);
            }
            return;
        }
        ProtoInstancePlaceHolder protoInstancePlaceHolder = null;
        VRMLPrototype vRMLPrototype = null;
        vRMLPrototype = this.protoMap.containsKey(string) ? (VRMLPrototype)this.protoMap.get(string) : (this.externProtoMap.containsKey(string) ? (VRMLPrototype)this.externProtoMap.get(string) : (this.globalProtoMap.containsKey(string) ? (VRMLPrototype)this.globalProtoMap.get(string) : (VRMLPrototype)this.globalExternProtoMap.get(string)));
        protoInstancePlaceHolder = vRMLPrototype != null ? new ProtoInstancePlaceHolder(vRMLPrototype, this.version, false) : this.nodeFactory.createVRMLNode(string, this.version, false);
        if (protoInstancePlaceHolder != null) {
            VRMLProtoInstance vRMLProtoInstance;
            VRMLNodeType vRMLNodeType;
            Class<?> clazz = protoInstancePlaceHolder.getClass();
            boolean bl = false;
            if (this.dontLoadTypes.contains(clazz)) {
                bl = true;
            } else if (protoInstancePlaceHolder instanceof VRMLProtoInstance && (vRMLNodeType = (vRMLProtoInstance = (VRMLProtoInstance)protoInstancePlaceHolder).getImplementationNode()) != null && this.dontLoadTypes.contains(vRMLNodeType.getClass())) {
                bl = true;
            }
            if (bl) {
                this.ignoreNodeCounter = 1;
                if (string2 != null) {
                    this.defMap.remove(string2);
                    this.ignoreDefSet.add((Object)string2);
                }
                return;
            }
        } else {
            this.ignoreNodeCounter = 1;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add((Object)string2);
            }
            return;
        }
        if (string2 != null) {
            protoInstancePlaceHolder.setDEF();
            this.ignoreDefSet.remove((Object)string2);
            this.defMap.put(string2, protoInstancePlaceHolder);
        }
        if (this.inProtoDecl && this.topOfStack == 0) {
            ((VRMLProtoDeclare)this.currentProto).addFieldNodeValue(this.currentFieldIndex, (VRMLNodeType)protoInstancePlaceHolder);
        } else {
            this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, (VRMLNodeType)protoInstancePlaceHolder);
        }
        ++this.topOfStack;
        this.nodeStack[this.topOfStack] = protoInstancePlaceHolder;
        this.currentNode = protoInstancePlaceHolder;
    }

    public void endNode() throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "End Node declaration in externproto");
        }
        if (this.ignoreNodeCounter > 0) {
            --this.ignoreNodeCounter;
            return;
        }
        this.nodeStack[this.topOfStack--] = null;
        if (this.topOfStack != -1) {
            this.currentNode = this.nodeStack[this.topOfStack];
            this.currentFieldIndex = this.childIndexStack[this.topOfStack];
        } else {
            this.currentNode = null;
            this.currentFieldIndex = -1;
        }
    }

    public void startField(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        int n = this.nodeStack[this.topOfStack].getFieldIndex(string);
        if (n == -1) {
            throw new InvalidFieldException("Unknown field name: " + string);
        }
        this.currentFieldIndex = n;
        this.childIndexStack[this.topOfStack] = n;
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (!this.inProtoDecl && !string.equals("NULL")) {
            this.currentNode.setRawValue(this.currentFieldIndex, string);
        }
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (!this.inProtoDecl && stringArray.length != 0) {
            this.currentNode.setRawValue(this.currentFieldIndex, stringArray);
        }
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        VRMLNodeType vRMLNodeType;
        if (this.inProtoDecl) {
            vRMLNodeType = (VRMLNodeType)this.globalDefMap.get(string);
        } else {
            if (this.ignoreNodeCounter > 0 || this.ignoreDefSet.contains((Object)string)) {
                return;
            }
            vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        }
        if (vRMLNodeType == null) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE declares an unknown source node DEF \"" + string + '\"');
        }
        if (this.inProtoDecl && this.topOfStack == 0) {
            if (this.currentProto.getPrimaryType() != 41) {
                if (vRMLNodeType instanceof VRMLBindableNodeType) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
                }
                if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains  bindable node(s).");
                }
            }
            ((VRMLProtoDeclare)this.currentProto).addFieldNodeValue(this.currentFieldIndex, vRMLNodeType);
        } else {
            if (!(this.nodeStack[this.topOfStack] instanceof VRMLScriptNodeType)) {
                if (vRMLNodeType instanceof VRMLBindableNodeType) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
                }
                if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains bindable node(s). \"" + string + '\"');
                }
            }
            this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, vRMLNodeType);
        }
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Nested PROTO declarations not allowed");
        }
        PrototypeDecl prototypeDecl = new PrototypeDecl(string, this.isVrml97);
        this.protoMap.put(string, prototypeDecl);
        this.protoDeclStack.push((Object)prototypeDecl);
        this.currentProto = prototypeDecl;
        if (this.rootProto == null) {
            this.topOfStack = 0;
            this.rootProto = prototypeDecl;
        }
        this.inProtoDecl = true;
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        this.inProtoDecl = false;
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        int n2;
        if (!this.inProtoDecl && !this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "proto field declaration not in proto!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentFieldIndex = n2 = this.currentProto.appendField(vRMLFieldDeclaration);
        if (object != null && this.currentProto instanceof VRMLProtoDeclare) {
            VRMLProtoDeclare vRMLProtoDeclare = (VRMLProtoDeclare)this.currentProto;
            if (object instanceof String) {
                vRMLProtoDeclare.setRawValue(n2, (String)object);
            } else {
                vRMLProtoDeclare.setRawValue(n2, (String[])object);
            }
        }
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (!(this.currentProto instanceof PrototypeDecl)) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "proto IS declaration not in proto!");
        }
        ((PrototypeDecl)this.currentProto).addIS(string, this.currentNode, this.currentFieldIndex);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Starting proto body while still in declaration");
        }
        this.currentNode = ((PrototypeDecl)this.currentProto).getBodyGroup();
        ++this.topOfStack;
        this.nodeStack[this.topOfStack] = this.currentNode;
        this.childIndexStack[this.topOfStack] = this.currentFieldIndex = this.currentNode.getFieldIndex("children");
        this.protoMapStack.push((Object)this.protoMap);
        this.defMapStack.push((Object)this.defMap);
        this.protoMap = new HashMap();
        this.defMap = new HashMap();
        this.inProtoBody = true;
    }

    public void endProtoBody() throws SAVException, VRMLException {
        this.currentProto = (AbstractProto)this.protoDeclStack.pop();
        --this.topOfStack;
        if (this.topOfStack >= 0) {
            this.currentNode = this.nodeStack[this.topOfStack];
            this.currentFieldIndex = this.childIndexStack[this.topOfStack];
            this.protoMap = (HashMap)this.protoMapStack.pop();
            this.defMap = (HashMap)this.defMapStack.pop();
        } else {
            this.inProtoBody = false;
            this.defMap = new HashMap();
            this.protoMap = new HashMap();
        }
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Nested PROTO declarations not allowed");
        }
        ExternalPrototypeDecl externalPrototypeDecl = new ExternalPrototypeDecl(string, this.isVrml97);
        this.externProtoMap.put(string, externalPrototypeDecl);
        this.currentProto = externalPrototypeDecl;
        this.rootProto = externalPrototypeDecl;
        this.topOfStack = 0;
        this.inExternProtoDecl = true;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.inExternProtoDecl = false;
        this.inExternProtoURI = true;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        if (!this.inExternProtoURI) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "EXTERNPROTO URI declaration not allowed here");
        }
        ((ExternalPrototypeDecl)this.currentProto).setUrl(stringArray);
        this.currentProto = null;
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode;
        this.scriptStack.push((Object)this.currentScript);
        this.inScript = true;
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.scriptStack.pop();
        if (this.currentScript == null) {
            this.inScript = false;
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        boolean bl;
        if (!this.inScript) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Script declaration not in script!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        int n2 = this.currentScript.appendField(vRMLFieldDeclaration);
        int n3 = vRMLFieldDeclaration.getFieldType();
        boolean bl2 = bl = n3 == 9 || n3 == 10;
        if (!(bl || n != 4 && n != 1)) {
            if (object instanceof String) {
                this.currentScript.setRawValue(n2, (String)object);
            } else if (object != null) {
                this.currentScript.setRawValue(n2, (String[])object);
            }
        }
        this.currentFieldIndex = n2;
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        if (this.ignoreDefSet.contains((Object)string) || this.ignoreDefSet.contains((Object)string3)) {
            return;
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source node DEF: " + string);
        }
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.defMap.get(string3);
        if (vRMLNodeType2 == null) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node DEF: " + string3);
        }
        int n = vRMLNodeType.getFieldIndex(string2);
        if (n == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source field: " + string2 + " for node: " + string);
        }
        int n2 = vRMLNodeType2.getFieldIndex(string4);
        if (n2 == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination field: " + string4 + " for node: " + string3);
        }
        ProtoROUTE protoROUTE = new ProtoROUTE(vRMLNodeType, n, vRMLNodeType2, n2);
        ((PrototypeDecl)this.currentProto).addRouteDecl(protoROUTE);
    }

    private final void resizeStack() {
        if (this.topOfStack + 1 == this.nodeStack.length) {
            int n = this.nodeStack.length;
            int n2 = n + 25;
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.nodeStack, 0, vRMLNodeTypeArray, 0, n);
            System.arraycopy(this.childIndexStack, 0, vRMLNodeTypeArray, 0, n);
            this.nodeStack = vRMLNodeTypeArray;
            this.childIndexStack = nArray;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

