/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.Iterator;
import java.util.List;
import org.web3d.util.ArrayUtils;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.ProtoScene;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLPrototype;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.EmptyProtoScene;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.parser.FieldParserFactory;

public class ProtoInstancePlaceHolder
extends AbstractProto
implements VRMLProtoInstance {
    private static final String FIELD_MSG = "Attempt to set unknown field index: ";
    private VRMLPrototype proto;
    private boolean hasDEF;
    private IntHashMap fieldValueMap;
    private ProtoScene scene;
    private VRMLNodeType implNode;
    private boolean isVrml97;
    private boolean inSetup;
    private boolean isStatic;
    private String vrmlVersion;
    private IntHashMap userData;
    private int refCount;

    public ProtoInstancePlaceHolder(VRMLPrototype vRMLPrototype, String string, boolean bl) {
        super(vRMLPrototype.getName(), false);
        Object object;
        this.proto = vRMLPrototype;
        this.hasDEF = false;
        this.isVrml97 = false;
        this.inSetup = true;
        this.vrmlVersion = string;
        this.isStatic = bl;
        this.userData = new IntHashMap();
        List list = vRMLPrototype.getAllFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (VRMLFieldDeclaration)iterator.next();
            try {
                this.appendField((VRMLFieldDeclaration)object);
            }
            catch (FieldExistsException fieldExistsException) {
                // empty catch block
            }
        }
        this.fieldValueMap = new IntHashMap(list.size());
        if (vRMLPrototype instanceof PrototypeDecl) {
            object = (PrototypeDecl)vRMLPrototype;
            VRMLGroupingNodeType vRMLGroupingNodeType = ((PrototypeDecl)object).getBodyGroup();
            VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
            this.implNode = vRMLNodeTypeArray[0];
            this.isVrml97 = ((AbstractProto)object).isVRML97();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
                    int n = vRMLFieldDeclaration.getAccessType();
                    if (n == 2 || n == 3) continue;
                    String string2 = vRMLFieldDeclaration.getName();
                    int n2 = ((AbstractProto)object).getFieldIndex(string2);
                    Object object2 = ((PrototypeDecl)object).getFieldValue(n2);
                    n2 = this.getFieldIndex(string2);
                    if (object2 instanceof String) {
                        this.setRawValue(n2, (String)object2);
                        continue;
                    }
                    if (object2 instanceof VRMLNodeType) {
                        this.setValue(n2, (VRMLNodeType)object2);
                        continue;
                    }
                    if (object2 instanceof String[]) {
                        this.setRawValue(n2, (String[])object2);
                        continue;
                    }
                    if (object2 instanceof VRMLNodeType) {
                        this.setValue(n2, (VRMLNodeType[])object2);
                        continue;
                    }
                    VRMLFieldData vRMLFieldData = new VRMLFieldData();
                    int n3 = vRMLFieldDeclaration.getFieldType();
                    if (n3 == 9) {
                        vRMLFieldData.dataType = (short)7;
                    } else if (n3 == 10) {
                        vRMLFieldData.dataType = (short)13;
                    } else {
                        System.out.println("Placeholder copy field type " + object);
                    }
                    this.fieldValueMap.put(n2, (Object)vRMLFieldData);
                }
                catch (FieldException fieldException) {
                    System.out.println("Waaaa! proto raw fields don't match!");
                    fieldException.printStackTrace();
                }
            }
        }
    }

    public VRMLNodeType getImplementationNode() {
        return this.implNode;
    }

    public VRMLPrototype getProtoDefinition() {
        return this.proto;
    }

    public BasicScene getContainedScene() {
        if (this.scene == null) {
            this.scene = new EmptyProtoScene();
        }
        return this.scene;
    }

    public void allEventsComplete() {
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        System.out.println("ProtoInstancePlaceHolder notifyExtern ProtoLoaded not implemented.");
    }

    public int getRefCount() {
        return this.refCount;
    }

    public synchronized int updateRefCount(boolean bl) {
        int n = this.refCount++;
        return n;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
    }

    public void setDEF() {
        this.hasDEF = true;
    }

    public boolean isDEF() {
        return this.hasDEF;
    }

    public int getPrimaryType() {
        return 38;
    }

    public int[] getSecondaryType() {
        return TypeConstants.NO_SECONDARY_TYPE;
    }

    public boolean hasFieldChanged(int n) {
        return false;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Invalid Index: " + n + " " + this);
        }
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldValueMap.get(n);
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
    }

    public void setRawValue(int n, String string) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration.getFieldType() == 23) {
            this.setValue(n, string);
        } else {
            this.createFieldParser();
            try {
                switch (vRMLFieldDeclaration.getFieldType()) {
                    case 1: {
                        this.setValue(n, this.fieldParser.SFInt32(string));
                        break;
                    }
                    case 2: {
                        this.setValue(n, this.fieldParser.MFInt32(string));
                        break;
                    }
                    case 17: {
                        this.setValue(n, this.fieldParser.SFImage(string));
                        break;
                    }
                    case 3: {
                        this.setValue(n, this.fieldParser.SFFloat(string));
                        break;
                    }
                    case 7: {
                        this.setValue(n, this.fieldParser.SFTime(string));
                        break;
                    }
                    case 5: {
                        this.setValue(n, this.fieldParser.SFDouble(string));
                        break;
                    }
                    case 8: {
                        this.setValue(n, this.fieldParser.MFTime(string));
                        break;
                    }
                    case 6: {
                        this.setValue(n, this.fieldParser.MFDouble(string));
                        break;
                    }
                    case 19: {
                        this.setValue(n, this.fieldParser.SFLong(string));
                        break;
                    }
                    case 20: {
                        this.setValue(n, this.fieldParser.MFLong(string));
                        break;
                    }
                    case 21: {
                        this.setValue(n, this.fieldParser.SFBool(string));
                        break;
                    }
                    case 22: {
                        this.setValue(n, this.fieldParser.MFBool(string));
                        break;
                    }
                    case 4: {
                        this.setValue(n, this.fieldParser.MFFloat(string));
                        break;
                    }
                    case 11: {
                        this.setValue(n, this.fieldParser.SFVec2f(string));
                        break;
                    }
                    case 13: {
                        this.setValue(n, this.fieldParser.SFVec3f(string));
                        break;
                    }
                    case 12: {
                        this.setValue(n, this.fieldParser.MFVec2f(string));
                        break;
                    }
                    case 14: {
                        this.setValue(n, this.fieldParser.MFVec3f(string));
                        break;
                    }
                    case 27: {
                        this.setValue(n, this.fieldParser.SFColor(string));
                        break;
                    }
                    case 28: {
                        this.setValue(n, this.fieldParser.MFColor(string));
                        break;
                    }
                    case 29: {
                        this.setValue(n, this.fieldParser.SFColorRGBA(string));
                        break;
                    }
                    case 30: {
                        this.setValue(n, this.fieldParser.MFColorRGBA(string));
                        break;
                    }
                    case 15: {
                        this.setValue(n, this.fieldParser.SFVec3d(string));
                        break;
                    }
                    case 16: {
                        this.setValue(n, this.fieldParser.MFVec3d(string));
                        break;
                    }
                    case 18: {
                        this.setValue(n, this.fieldParser.MFImage(string));
                    }
                }
            }
            catch (Exception exception) {
                throw new InvalidFieldFormatException("ProtoName: " + this.proto.getName() + " " + exception.getMessage());
            }
        }
    }

    public void setRawValue(int n, String[] stringArray) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration.getFieldType() == 24) {
            this.setValue(n, stringArray);
        } else {
            this.createFieldParser();
            try {
                this.setValue(n, this.fieldParser.MFString(stringArray));
            }
            catch (Exception exception) {
                throw new InvalidFieldFormatException(exception.getMessage());
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(int) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.intValue = n2;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)2;
            vRMLFieldData.intValue = n2;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, int[] nArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(int[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.intArrayValue = nArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)9;
            vRMLFieldData.intArrayValue = nArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(boolean) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.booleanValue = bl;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = 1;
            vRMLFieldData.booleanValue = bl;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, boolean[] blArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(boolean[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.booleanArrayValue = blArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)8;
            vRMLFieldData.booleanArrayValue = blArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(float) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.floatValue = f;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)4;
            vRMLFieldData.floatValue = f;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, float[] fArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(float[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.floatArrayValue = fArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)11;
            vRMLFieldData.floatArrayValue = fArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, float[][] fArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        float[] fArray2 = null;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 12: {
                fArray2 = new float[fArray.length * 2];
                ArrayUtils.flatten2((float[][])fArray, (int)fArray.length, (float[])fArray2);
                break;
            }
            case 14: 
            case 28: {
                fArray2 = new float[fArray.length * 3];
                ArrayUtils.flatten3((float[][])fArray, (int)fArray.length, (float[])fArray2);
                break;
            }
            case 26: {
                fArray2 = new float[fArray.length * 4];
                ArrayUtils.flatten4((float[][])fArray, (int)fArray.length, (float[])fArray2);
            }
        }
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(float[][]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.floatArrayValue = fArray2;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)11;
            vRMLFieldData.floatArrayValue = fArray2;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(long) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.longValue = l;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)3;
            vRMLFieldData.longValue = l;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, long[] lArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(long[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.longArrayValue = lArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)10;
            vRMLFieldData.longArrayValue = lArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(double) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.doubleValue = d;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)5;
            vRMLFieldData.doubleValue = d;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, double[] dArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(double[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.doubleArrayValue = dArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)12;
            vRMLFieldData.doubleArrayValue = dArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, double[][] dArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        double[] dArray2 = new double[dArray.length * 3];
        ArrayUtils.flatten3((double[][])dArray, (int)dArray.length, (double[])dArray2);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(double[][]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.doubleArrayValue = dArray2;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)12;
            vRMLFieldData.doubleArrayValue = dArray2;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(String) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.stringValue = string;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)6;
            vRMLFieldData.stringValue = string;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, String[] stringArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(String[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.stringArrayValue = stringArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)14;
            vRMLFieldData.stringArrayValue = stringArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(child) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.nodeValue = vRMLNodeType;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)7;
            vRMLFieldData.nodeValue = vRMLNodeType;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldException, InvalidFieldValueException {
        Object object = this.fieldValueMap.get(n);
        if (!this.inSetup) {
            if (object == null) {
                throw new InvalidFieldException("(child[]) Attempt to set unknown field index: " + n);
            }
            VRMLFieldData vRMLFieldData = (VRMLFieldData)object;
            vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
        } else {
            VRMLFieldData vRMLFieldData = new VRMLFieldData();
            vRMLFieldData.dataType = (short)13;
            vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
            this.fieldValueMap.put(n, (Object)vRMLFieldData);
        }
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        return this.userData.get(n);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        this.inSetup = false;
        this.fieldParser = null;
    }

    public void setVersion(String string, boolean bl) {
        this.vrmlVersion = string;
        this.isStatic = bl;
    }

    protected void createFieldParser() {
        if (this.fieldParser == null) {
            FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
            this.fieldParser = fieldParserFactory.newFieldParser(this.vrmlVersion);
        }
    }
}

