/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ProtoBodyGroupNode;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.ProtoROUTE;

public class PrototypeDecl
extends AbstractProto
implements VRMLProtoDeclare {
    private static final String NO_FIELD_MSG = "No field at index ";
    private static final String EVENTIN_MSG = "No value, field is an eventIn ";
    private ProtoBodyGroupNode bodyGroup = new ProtoBodyGroupNode();
    private HashMap isMap = new HashMap();
    private HashSet routes;
    private VRMLFieldData fieldData;
    private IntHashMap fieldValueMap = new IntHashMap();

    public PrototypeDecl(String string) {
        this(string, false);
    }

    public PrototypeDecl(String string, boolean bl) {
        super(string, bl);
        this.routes = new HashSet();
    }

    public void addFieldNodeValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        LinkedList<VRMLNodeType> linkedList = (LinkedList<VRMLNodeType>)this.fieldValueMap.get(n);
        if (linkedList == null) {
            linkedList = new LinkedList<VRMLNodeType>();
            this.fieldValueMap.put(n, linkedList);
        }
        linkedList.add(vRMLNodeType);
    }

    public void setRawValue(int n, String string) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        this.fieldValueMap.put(n, (Object)string);
    }

    public void setRawValue(int n, String[] stringArray) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        this.fieldValueMap.put(n, (Object)stringArray);
    }

    public Object getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        if (vRMLFieldDeclaration.getAccessType() == 2) {
            throw new InvalidFieldException(EVENTIN_MSG + vRMLFieldDeclaration.getName());
        }
        return this.fieldValueMap.get(n);
    }

    public int getPrimaryType() {
        return this.bodyGroup.getPrimaryType();
    }

    public void addRouteDecl(ProtoROUTE protoROUTE) {
        this.routes.add(protoROUTE);
    }

    public Set getRouteDecls() {
        return Collections.unmodifiableSet(this.routes);
    }

    public VRMLGroupingNodeType getBodyGroup() {
        return this.bodyGroup;
    }

    public void addIS(String string, VRMLNodeType vRMLNodeType, int n) throws InvalidFieldException, InvalidFieldConnectionException {
        ArrayList<ProtoFieldInfo> arrayList;
        Integer n2 = (Integer)this.fieldIndexMap.get(string);
        if (n2 == null) {
            throw new InvalidFieldException("Source for IS not known", string);
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n2);
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(n);
        if (vRMLFieldDeclaration2 == null) {
            System.out.println("dest: " + vRMLNodeType);
            throw new InvalidFieldException("Destination for IS not known.  destNode: " + vRMLNodeType.getVRMLNodeName() + " fromField: " + string + " toIdx: " + n);
        }
        if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType()) {
            throw new InvalidFieldConnectionException("No match on IS data types. Source (" + vRMLFieldDeclaration.getName() + ") is " + vRMLFieldDeclaration.getFieldTypeString() + " and destination (" + vRMLFieldDeclaration2.getName() + ") is " + vRMLFieldDeclaration2.getFieldTypeString());
        }
        if (this.isVRML97()) {
            this.checkAccessMatch(vRMLFieldDeclaration, vRMLFieldDeclaration2);
        }
        if ((arrayList = (ArrayList<ProtoFieldInfo>)this.isMap.get(n2)) == null) {
            arrayList = new ArrayList<ProtoFieldInfo>(5);
            this.isMap.put(n2, arrayList);
        }
        arrayList.add(new ProtoFieldInfo(vRMLNodeType, n));
    }

    public Map getISMaps() {
        return Collections.unmodifiableMap(this.isMap);
    }

    private void checkAccessMatch(VRMLFieldDeclaration vRMLFieldDeclaration, VRMLFieldDeclaration vRMLFieldDeclaration2) throws InvalidFieldConnectionException {
        int n = vRMLFieldDeclaration2.getAccessType();
        switch (vRMLFieldDeclaration.getAccessType()) {
            case 1: {
                if (n == 1) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an exposedField and destination is not an exposedField");
            }
            case 4: {
                if (n != 2 && n != 3) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is a field  and destination is not field or exposedField");
            }
            case 2: {
                if (n != 4 && n != 3) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an eventIn  and destination is a field or eventOut");
            }
            case 3: {
                if (n != 4 && n != 2) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an eventOut  and destination is a field or eventIn");
            }
        }
    }
}

