/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.web3d.vrml.nodes.runtime.InputEventBuffer;

public class AWTListenerEventBuffer
implements InputEventBuffer,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final int DEFAULT_SIZE = 1024;
    private static final int INCREMENT_SIZE = 128;
    private Object keyMutex = new Object();
    private Object mouseMutex = new Object();
    private int numKeyEvents = 0;
    private KeyEvent[] keyEvents = new KeyEvent[1024];
    private int numMouseEvents = 0;
    private MouseEvent[] mouseEvents = new MouseEvent[1024];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyEvents(KeyEvent[] keyEventArray) {
        int n = this.numKeyEvents;
        if (this.numKeyEvents != 0) {
            Object object = this.keyMutex;
            synchronized (object) {
                int n2 = keyEventArray.length < this.numKeyEvents ? keyEventArray.length : this.numKeyEvents;
                System.arraycopy(this.keyEvents, 0, keyEventArray, 0, n2);
                int n3 = this.numKeyEvents;
                while (--n3 >= 0) {
                    this.keyEvents[n3] = null;
                }
                this.numKeyEvents = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMouseEvents(MouseEvent[] mouseEventArray) {
        int n = this.numMouseEvents;
        if (this.numMouseEvents != 0) {
            Object object = this.mouseMutex;
            synchronized (object) {
                int n2 = mouseEventArray.length < this.numMouseEvents ? mouseEventArray.length : this.numMouseEvents;
                System.arraycopy(this.mouseEvents, 0, mouseEventArray, 0, n2);
                int n3 = this.numMouseEvents;
                while (--n3 >= 0) {
                    this.mouseEvents[n3] = null;
                }
                this.numMouseEvents = 0;
            }
        }
        return n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.addMouseEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyEvent(KeyEvent keyEvent) {
        Object object = this.keyMutex;
        synchronized (object) {
            if (this.numKeyEvents == this.keyEvents.length) {
                KeyEvent[] keyEventArray = new KeyEvent[this.numKeyEvents + 128];
                System.arraycopy(this.keyEvents, 0, keyEventArray, 0, this.numKeyEvents);
                this.keyEvents = keyEventArray;
            }
            this.keyEvents[this.numKeyEvents++] = keyEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMouseEvent(MouseEvent mouseEvent) {
        Object object = this.mouseMutex;
        synchronized (object) {
            if (this.numMouseEvents == this.mouseEvents.length) {
                MouseEvent[] mouseEventArray = new MouseEvent[this.numMouseEvents + 128];
                System.arraycopy(this.mouseEvents, 0, mouseEventArray, 0, this.numMouseEvents);
                this.mouseEvents = mouseEventArray;
            }
            this.mouseEvents[this.numMouseEvents++] = mouseEvent;
        }
    }
}

