/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.nodes.VRMLBindableNodeListener;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeListener;

public class BindableNodeManager
implements VRMLBindableNodeListener {
    private SimpleStack nodeStack = new SimpleStack();
    private BindableNodeListener listener;
    private VRMLClock clock;
    private HashSet nodeSet = new HashSet();
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private VRMLBindableNodeType firstNode;

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
    }

    public VRMLBindableNodeType getBoundNode() {
        return (VRMLBindableNodeType)this.nodeStack.peek();
    }

    public VRMLBindableNodeType getFirstNode() {
        return this.firstNode;
    }

    public void addNode(VRMLBindableNodeType vRMLBindableNodeType) {
        vRMLBindableNodeType.addBindableNodeListener((VRMLBindableNodeListener)this);
        this.nodeSet.add((Object)vRMLBindableNodeType);
        if (this.firstNode == null) {
            this.firstNode = vRMLBindableNodeType;
        }
    }

    public void removeNode(VRMLBindableNodeType vRMLBindableNodeType) {
        vRMLBindableNodeType.removeBindableNodeListener((VRMLBindableNodeListener)this);
        this.nodeSet.remove((Object)vRMLBindableNodeType);
    }

    public void clearAll() {
        Object[] objectArray = this.nodeSet.toArray();
        int n = 0;
        while (n < objectArray.length) {
            VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)objectArray[n];
            vRMLBindableNodeType.removeBindableNodeListener((VRMLBindableNodeListener)this);
            ++n;
        }
        this.nodeSet.clear();
        this.nodeStack.clear();
        this.firstNode = null;
    }

    public void setNodeChangeListener(BindableNodeListener bindableNodeListener) {
        this.listener = bindableNodeListener;
    }

    public void nodeIsBound(VRMLNodeType vRMLNodeType, boolean bl) {
        block10: {
            VRMLNodeType vRMLNodeType2;
            block11: {
                block9: {
                    if (!bl) break block9;
                    if (this.nodeStack.contains((Object)vRMLNodeType)) {
                        this.nodeStack.remove((Object)vRMLNodeType);
                    }
                    VRMLNodeType vRMLNodeType3 = null;
                    if (this.nodeStack.size() != 0) {
                        vRMLNodeType3 = (VRMLNodeType)this.nodeStack.peek();
                    }
                    this.nodeStack.push((Object)vRMLNodeType);
                    if (vRMLNodeType instanceof VRMLBindableNodeType) {
                        VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType;
                        vRMLBindableNodeType.setOnStack(true);
                        if (vRMLNodeType3 != null && vRMLNodeType3 != vRMLNodeType) {
                            VRMLBindableNodeType vRMLBindableNodeType2 = (VRMLBindableNodeType)vRMLNodeType3;
                            vRMLBindableNodeType2.setBind(false, false, 0.0);
                        }
                    }
                    if (this.listener == null) break block10;
                    try {
                        this.listener.newNodeBound((VRMLBindableNodeType)vRMLNodeType);
                    }
                    catch (Exception exception) {
                        this.errorReporter.errorReport("Error sending bind update ", exception);
                    }
                    break block10;
                }
                vRMLNodeType2 = (VRMLNodeType)this.nodeStack.peek();
                if (vRMLNodeType2 == vRMLNodeType) break block11;
                this.nodeStack.remove((Object)vRMLNodeType);
                if (!(vRMLNodeType instanceof VRMLBindableNodeType)) break block10;
                VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType2;
                vRMLBindableNodeType.setOnStack(false);
                break block10;
            }
            this.nodeStack.pop();
            vRMLNodeType2 = (VRMLNodeType)this.nodeStack.peek();
            if (vRMLNodeType2 instanceof VRMLBindableNodeType) {
                VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)vRMLNodeType2;
                vRMLBindableNodeType.setOnStack(false);
            }
            if (this.listener == null) break block10;
            try {
                this.listener.newNodeBound((VRMLBindableNodeType)vRMLNodeType2);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error sending bind update ", exception);
            }
        }
    }
}

