/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.loader.ScriptLoadStatusListener;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.util.NodeArray;

public class DefaultScriptManager
implements ScriptManager,
VRMLUrlListener,
ScriptLoadStatusListener {
    private ErrorReporter errorReporter;
    private ScriptLoader loader;
    private NodeArray loadedList;
    private NodeArray processedList;
    private NodeArray shutdownList;
    private NodeArray deletedList;
    private HashSet allScripts;
    private Object loadedListMutex = new Object();
    private Object processedListMutex = new Object();

    public DefaultScriptManager() {
        this.loadedList = new NodeArray();
        this.shutdownList = new NodeArray();
        this.deletedList = new NodeArray();
        this.processedList = new NodeArray();
        this.allScripts = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void urlChanged(VRMLNodeType vRMLNodeType, int n) {
        this.shutdownList.add(vRMLNodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCompleted(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object = this.loadedListMutex;
        synchronized (object) {
            this.loadedList.add((VRMLNodeType)vRMLScriptNodeType);
        }
        Object object2 = this.processedListMutex;
        synchronized (object2) {
            this.processedList.add((VRMLNodeType)vRMLScriptNodeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFailed(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object = this.processedListMutex;
        synchronized (object) {
            this.processedList.add((VRMLNodeType)vRMLScriptNodeType);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setScriptLoader(ScriptLoader scriptLoader) {
        if (this.loader != null) {
            this.loader.setStatusListener(null);
        }
        this.loader = scriptLoader;
        if (this.loader != null) {
            this.loader.setStatusListener(this);
        }
    }

    public ScriptLoader getScriptLoader() {
        return this.loader;
    }

    public void shutdownActiveScripts() {
        int n = this.shutdownList.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.shutdownList.get(n2);
            vRMLScriptNodeType.shutdown();
            ++n2;
        }
        this.shutdownList.clear();
    }

    public void shutdown() {
        Object[] objectArray = this.allScripts.toArray();
        int n = 0;
        while (n < objectArray.length) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)objectArray[n];
            vRMLScriptNodeType.shutdownAll();
            ++n;
        }
        this.shutdownList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeScripts() {
        int n = this.loadedList.size();
        if (n != 0) {
            Object object = this.loadedListMutex;
            synchronized (object) {
                int n2 = 0;
                while (n2 < n) {
                    VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.loadedList.get(n2);
                    vRMLScriptNodeType.initialize();
                    ++n2;
                }
                this.loadedList.clear();
            }
        }
    }

    public void removeScripts(NodeArray nodeArray) {
        int n = nodeArray.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)nodeArray.get(n2);
            vRMLScriptNodeType.removeUrlListener((VRMLUrlListener)this);
            this.allScripts.remove((Object)vRMLScriptNodeType);
            ++n2;
        }
    }

    public void addScripts(NodeArray nodeArray) {
        int n = nodeArray.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)nodeArray.get(n2);
            vRMLScriptNodeType.addUrlListener((VRMLUrlListener)this);
            this.allScripts.add((Object)vRMLScriptNodeType);
            this.loader.loadScript(vRMLScriptNodeType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProcessedScripts(NodeArray nodeArray) {
        Object object = this.processedListMutex;
        synchronized (object) {
            nodeArray.set(this.processedList);
            this.processedList.clear();
        }
    }
}

