/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.SceneTreeNode;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.util.NodeArray;

public class GeneralisedEventModelEvaluator
implements EventModelEvaluator {
    private static final int NUM_NODES = 32;
    private static final int NUM_NODES_INC = 8;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private EventModelInitListener initListener;
    private SensorManager sensorManager;
    private RouteManager routeManager;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ExternalLoadManager contentLoader;
    private ArrayList externalViews = new ArrayList();
    private IntHashMap bindablesMap = new IntHashMap();
    private VRMLScene currentScene;
    private boolean active = false;
    private VRMLNodeType[] tmpNodes;
    private NodeArray tmpArray;
    private SceneTreeNode sceneTreeRoot;
    private HashMap scriptTreeMap = new HashMap();
    private HashMap sceneTreeMap;
    private HashMap spaceParentMap = new HashMap();
    private boolean justStarted = false;
    private VRMLExecutionSpace root_space;

    public GeneralisedEventModelEvaluator() {
        this.sceneTreeMap = new HashMap();
        this.tmpNodes = new VRMLNodeType[32];
        this.tmpArray = new NodeArray(32);
    }

    public void initialize(ScriptManager scriptManager, RouteManager routeManager, SensorManager sensorManager, FrameStateManager frameStateManager, ExternalLoadManager externalLoadManager) {
        this.scriptManager = scriptManager;
        this.routeManager = routeManager;
        this.sensorManager = sensorManager;
        this.stateManager = frameStateManager;
        this.contentLoader = externalLoadManager;
        VRMLClock vRMLClock = this.sensorManager.getVRMLClock();
        BindableNodeManager bindableNodeManager = new BindableNodeManager();
        bindableNodeManager.setVRMLClock(vRMLClock);
        bindableNodeManager.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(55, (Object)bindableNodeManager);
        BindableNodeManager bindableNodeManager2 = new BindableNodeManager();
        bindableNodeManager2.setVRMLClock(vRMLClock);
        bindableNodeManager2.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(31, (Object)bindableNodeManager2);
        BindableNodeManager bindableNodeManager3 = new BindableNodeManager();
        bindableNodeManager3.setVRMLClock(vRMLClock);
        bindableNodeManager3.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(4, (Object)bindableNodeManager3);
        if (this.sensorManager != null) {
            this.sensorManager.setNavigationStacks(bindableNodeManager, bindableNodeManager2, bindableNodeManager3);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.scriptManager.setErrorReporter(this.errorReporter);
        this.routeManager.setErrorReporter(this.errorReporter);
        this.sensorManager.setErrorReporter(this.errorReporter);
        this.stateManager.setErrorReporter(this.errorReporter);
        this.contentLoader.setErrorReporter(this.errorReporter);
        int[] nArray = this.bindablesMap.keySet();
        int n = 0;
        while (n < nArray.length) {
            BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(nArray[n]);
            bindableNodeManager.setErrorReporter(this.errorReporter);
            ++n;
        }
    }

    public BindableNodeManager getBindableManager(int n) {
        BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(n);
        if (bindableNodeManager == null) {
            bindableNodeManager = new BindableNodeManager();
            bindableNodeManager.setErrorReporter(this.errorReporter);
            bindableNodeManager.setVRMLClock(this.sensorManager.getVRMLClock());
            this.bindablesMap.put(n, (Object)bindableNodeManager);
        }
        return bindableNodeManager;
    }

    public VRMLClock getVRMLClock() {
        return this.sensorManager.getVRMLClock();
    }

    public void addExternalView(ExternalView externalView) {
        if (!this.externalViews.contains(externalView)) {
            this.externalViews.add(externalView);
        }
    }

    public void removeExternalView(ExternalView externalView) {
        this.externalViews.remove(externalView);
    }

    public void setScene(VRMLScene vRMLScene) {
        if (this.active) {
            this.clear();
        }
        this.currentScene = vRMLScene;
        if (vRMLScene == null) {
            this.active = false;
            return;
        }
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)vRMLScene.getRootNode();
        this.spaceParentMap.put(vRMLExecutionSpace, null);
        this.sceneTreeRoot = new SceneTreeNode();
        this.sceneTreeRoot.scene = vRMLScene;
        this.sceneTreeRoot.space = vRMLExecutionSpace;
        this.sceneTreeMap.put(vRMLScene, this.sceneTreeRoot);
        this.loadScene(vRMLExecutionSpace, this.sceneTreeRoot);
        this.routeManager.updateSpaces();
        this.routeManager.updateRoutes();
        this.active = true;
        this.justStarted = this.sceneTreeRoot.completedScripts >= this.sceneTreeRoot.scriptsToLoad;
    }

    public void clear() {
        this.active = false;
        this.scriptManager.shutdown();
        this.routeManager.clear();
        this.sensorManager.clear();
        this.stateManager.clear();
        this.contentLoader.clear();
        this.scriptTreeMap.clear();
        this.spaceParentMap.clear();
        int[] nArray = this.bindablesMap.keySet();
        int n = 0;
        while (n < nArray.length) {
            BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(nArray[n]);
            bindableNodeManager.clearAll();
            ++n;
        }
        this.sceneTreeRoot = null;
        this.currentScene = null;
        this.root_space = null;
    }

    public void evaluate(double d) {
        if (!this.active) {
            return;
        }
        if (this.sceneTreeRoot.completedScripts < this.sceneTreeRoot.scriptsToLoad) {
            this.evaluateTimeZero(d);
        } else {
            if (this.justStarted) {
                if (this.initListener != null) {
                    try {
                        this.initListener.worldInitComplete();
                    }
                    catch (Exception exception) {
                        this.errorReporter.warningReport("Error sending core init", exception);
                    }
                }
                this.justStarted = false;
            }
            this.evaluateRunning(d);
        }
    }

    public void setInitListener(EventModelInitListener eventModelInitListener) {
        this.initListener = eventModelInitListener;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public ExternalLoadManager getContentLoader() {
        return this.contentLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    private void evaluateTimeZero(double d) {
        this.processScripts();
        if (this.sceneTreeRoot.completedScripts < this.sceneTreeRoot.scriptsToLoad) {
            return;
        }
        this.scriptManager.initializeScripts();
        this.routeManager.processRoutes(d);
        this.routeManager.updateSpaces();
        NodeArray nodeArray = this.stateManager.getAddedUrlNodes();
        this.processNewInlines(nodeArray);
        this.contentLoader.queueNodesLoad(nodeArray);
        this.processBindables();
        this.routeManager.updateRoutes();
        this.routeManager.endCascade();
        this.sensorManager.addSensors(this.stateManager.getAddedSensors());
        this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
        this.scriptManager.addScripts(this.stateManager.getAddedScripts());
        this.stateManager.clearRemovedNodes();
        this.stateManager.clearAddedNodes();
        this.stateManager.frameFinished();
        this.justStarted = true;
    }

    private void evaluateRunning(double d) {
        Object object;
        this.processSceneTree(this.sceneTreeRoot);
        this.sensorManager.processUserInput(d);
        int n = 0;
        while (n < this.externalViews.size()) {
            object = (ExternalView)this.externalViews.get(n);
            object.processEvents();
            ++n;
        }
        object = this.stateManager.getAddedUrlNodes();
        this.processNewInlines((NodeArray)object);
        this.routeManager.processRoutes(d);
        this.loadScenes(this.stateManager.getAddedScenes());
        this.stateManager.clearAddedScenes();
        this.contentLoader.queueNodesLoad((NodeArray)object);
        do {
            this.scriptManager.shutdownActiveScripts();
            this.scriptManager.removeScripts(this.stateManager.getRemovedScripts());
            this.sensorManager.removeSensors(this.stateManager.getRemovedSensors());
            this.sensorManager.removeViewDependentNodes(this.stateManager.getRemovedViewDependents());
            this.routeManager.updateSpaces();
            this.processBindables();
            this.routeManager.updateRoutes();
            this.routeManager.endCascade();
            this.sensorManager.addSensors(this.stateManager.getAddedSensors());
            this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
            this.processScripts();
            this.scriptManager.addScripts(this.stateManager.getAddedScripts());
            this.scriptManager.initializeScripts();
            this.stateManager.clearRemovedNodes();
            this.stateManager.clearAddedNodes();
        } while (this.routeManager.processRoutes(d));
        this.stateManager.frameFinished();
        this.sensorManager.updateViewMatrix();
    }

    private void processSceneTree(SceneTreeNode sceneTreeNode) {
        int n;
        if (!(sceneTreeNode.isActive || sceneTreeNode.space instanceof VRMLProtoInstance && !((CRProtoInstance)sceneTreeNode.space).getComplete())) {
            sceneTreeNode.isActive = true;
            this.contentLoader.queueSceneLoad(sceneTreeNode.scene);
            this.routeManager.addSpace(sceneTreeNode.space);
            this.sensorManager.loadScene(sceneTreeNode.scene);
        }
        if ((n = sceneTreeNode.children.size()) == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            SceneTreeNode sceneTreeNode2 = (SceneTreeNode)sceneTreeNode.children.get(n2);
            if (sceneTreeNode2.completedScripts >= sceneTreeNode2.scriptsToLoad) {
                this.processSceneTree(sceneTreeNode2);
            }
            ++n2;
        }
    }

    private void processBindables() {
        BindableNodeManager bindableNodeManager;
        VRMLNodeType vRMLNodeType;
        NodeArray nodeArray = this.stateManager.getRemovedBindables();
        int n = nodeArray.size();
        int n2 = 0;
        while (n2 < n) {
            vRMLNodeType = nodeArray.get(n2);
            bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(vRMLNodeType.getPrimaryType());
            if (bindableNodeManager == null) {
                this.errorReporter.warningReport("attempting to remove a bindable node that has no manager", null);
            } else {
                bindableNodeManager.removeNode((VRMLBindableNodeType)vRMLNodeType);
            }
            ++n2;
        }
        nodeArray = this.stateManager.getAddedBindables();
        n = nodeArray.size();
        n2 = 0;
        while (n2 < n) {
            vRMLNodeType = nodeArray.get(n2);
            bindableNodeManager = this.getBindableManager(vRMLNodeType.getPrimaryType());
            bindableNodeManager.addNode((VRMLBindableNodeType)vRMLNodeType);
            ++n2;
        }
    }

    private void processScripts() {
        this.scriptManager.getProcessedScripts(this.tmpArray);
        int n = this.tmpArray.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLExecutionSpace vRMLExecutionSpace;
            SceneTreeNode sceneTreeNode = (SceneTreeNode)this.scriptTreeMap.get(this.tmpArray.get(n2));
            ++sceneTreeNode.completedScripts;
            while ((vRMLExecutionSpace = (VRMLExecutionSpace)this.spaceParentMap.get(sceneTreeNode.space)) != null) {
                BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
                sceneTreeNode = (SceneTreeNode)this.sceneTreeMap.get(basicScene);
                ++sceneTreeNode.completedScripts;
            }
            ++n2;
        }
        this.tmpArray.clear();
    }

    private void loadScenes(ObjectArray objectArray) {
        int n = objectArray.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)objectArray.get(n2);
            VRMLExecutionSpace vRMLExecutionSpace2 = (VRMLExecutionSpace)this.spaceParentMap.get(vRMLExecutionSpace);
            if (vRMLExecutionSpace2 != null) {
                BasicScene basicScene = vRMLExecutionSpace2.getContainedScene();
                SceneTreeNode sceneTreeNode = (SceneTreeNode)this.sceneTreeMap.get(basicScene);
                BasicScene basicScene2 = vRMLExecutionSpace.getContainedScene();
                if (basicScene2 != null) {
                    SceneTreeNode sceneTreeNode2 = new SceneTreeNode();
                    sceneTreeNode2.scene = basicScene2;
                    sceneTreeNode2.space = vRMLExecutionSpace;
                    sceneTreeNode.children.add((Object)sceneTreeNode2);
                    this.sceneTreeMap.put(basicScene2, sceneTreeNode2);
                    this.loadScene(vRMLExecutionSpace, sceneTreeNode2);
                }
            }
            ++n2;
        }
    }

    private int loadScene(VRMLExecutionSpace vRMLExecutionSpace, SceneTreeNode sceneTreeNode) {
        SceneTreeNode sceneTreeNode2;
        BasicScene basicScene;
        BindableNodeManager bindableNodeManager;
        VRMLScriptNodeType vRMLScriptNodeType;
        int n;
        BasicScene basicScene2 = sceneTreeNode.scene;
        ArrayList arrayList = basicScene2.getByPrimaryType(41);
        int n2 = arrayList.size();
        if (n2 != 0) {
            sceneTreeNode.scriptsToLoad = n2;
            n = 0;
            while (n < n2) {
                vRMLScriptNodeType = (VRMLScriptNodeType)arrayList.get(n);
                this.scriptTreeMap.put(vRMLScriptNodeType, sceneTreeNode);
                vRMLScriptNodeType.setExecutionSpace(vRMLExecutionSpace);
                ++n;
            }
            this.checkTmpArray(n2);
            arrayList.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n2);
            this.scriptManager.addScripts(this.tmpArray);
            this.tmpArray.clear();
        }
        arrayList = basicScene2.getBySecondaryType(5);
        n2 = arrayList.size();
        n = 0;
        while (n < n2) {
            vRMLScriptNodeType = (VRMLNodeType)arrayList.get(n);
            bindableNodeManager = this.getBindableManager(vRMLScriptNodeType.getPrimaryType());
            bindableNodeManager.addNode((VRMLBindableNodeType)vRMLScriptNodeType);
            ++n;
        }
        arrayList = basicScene2.getByPrimaryType(38);
        n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            bindableNodeManager = (VRMLProtoInstance)arrayList.get(n3);
            basicScene = bindableNodeManager.getContainedScene();
            this.spaceParentMap.put(bindableNodeManager, vRMLExecutionSpace);
            if (basicScene != null) {
                sceneTreeNode2 = new SceneTreeNode();
                sceneTreeNode2.scene = basicScene;
                sceneTreeNode2.space = bindableNodeManager;
                sceneTreeNode.children.add((Object)sceneTreeNode2);
                this.sceneTreeMap.put(basicScene, sceneTreeNode2);
                sceneTreeNode.scriptsToLoad += this.loadScene((VRMLExecutionSpace)bindableNodeManager, sceneTreeNode2);
            }
            ++n3;
        }
        arrayList = basicScene2.getByPrimaryType(24);
        n2 = arrayList.size();
        int n4 = 0;
        while (n4 < n2) {
            basicScene = (VRMLInlineNodeType)arrayList.get(n4);
            sceneTreeNode2 = basicScene.getContainedScene();
            this.spaceParentMap.put(basicScene, vRMLExecutionSpace);
            if (sceneTreeNode2 != null) {
                SceneTreeNode sceneTreeNode3 = new SceneTreeNode();
                sceneTreeNode3.scene = sceneTreeNode2;
                sceneTreeNode3.space = basicScene;
                sceneTreeNode.children.add((Object)sceneTreeNode3);
                this.sceneTreeMap.put(sceneTreeNode2, sceneTreeNode3);
                this.loadScene((VRMLExecutionSpace)basicScene, sceneTreeNode3);
            }
            ++n4;
        }
        return sceneTreeNode.scriptsToLoad;
    }

    private void checkTmpArray(int n) {
        if (this.tmpNodes.length < n) {
            int n2 = this.tmpNodes.length + 8;
            while (n2 < n) {
                n2 += 8;
            }
            this.tmpNodes = new VRMLNodeType[n2];
        }
    }

    private void processNewInlines(NodeArray nodeArray) {
        int n = nodeArray.size();
        int n2 = 0;
        while (n2 < n) {
            VRMLExternalNodeType vRMLExternalNodeType = (VRMLExternalNodeType)nodeArray.get(n2);
            if (vRMLExternalNodeType instanceof VRMLInlineNodeType) {
                VRMLInlineNodeType vRMLInlineNodeType = (VRMLInlineNodeType)vRMLExternalNodeType;
                VRMLExecutionSpace vRMLExecutionSpace = vRMLInlineNodeType.getParentSpace();
                if (vRMLExecutionSpace == null) {
                    vRMLExecutionSpace = this.root_space;
                }
                this.spaceParentMap.put(vRMLInlineNodeType, vRMLExecutionSpace);
            }
            ++n2;
        }
    }
}

