/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.SceneGraphTraversalObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGeometricPropertyNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.util.NodeArray;

public class GeneralisedFrameStateManager
implements FrameStateManager,
SceneGraphTraversalObserver {
    private static final int NUM_FRAME_LISTENERS = 20;
    private static final int NUM_FRAME_INC = 5;
    private static final String EOF_NOTIF_MSG = "An error was generated during the end of frame processing";
    private HashSet registeredFrameStateListeners;
    private FrameStateListener[] currentFrameListeners;
    private int lastFrameStateIndex;
    private ErrorReporter errorReporter;
    private NodeArray[] removedScripts = new NodeArray[2];
    private NodeArray[] addedScripts;
    private NodeArray[] removedSensors;
    private NodeArray[] addedSensors;
    private NodeArray[] addedUrls;
    private NodeArray[] removedViewDependentNodes;
    private NodeArray[] addedViewDependentNodes;
    private NodeArray[] removedBindables;
    private NodeArray[] addedBindables;
    private ObjectArray[] addedScenes;
    private ObjectArray[] removedScenes;
    protected SceneGraphTraverser traverser;
    private boolean addTraversal;
    private int idxRScripts;
    private int idxAScripts;
    private int idxRSensors;
    private int idxASensors;
    private int idxAUrls;
    private int idxAViewDependents;
    private int idxRViewDependents;
    private int idxRBindables;
    private int idxABindables;
    private int idxRScenes;
    private int idxAScenes;

    public GeneralisedFrameStateManager() {
        this.removedScripts[0] = new NodeArray();
        this.removedScripts[1] = new NodeArray();
        this.addedScripts = new NodeArray[2];
        this.addedScripts[0] = new NodeArray();
        this.addedScripts[1] = new NodeArray();
        this.removedSensors = new NodeArray[2];
        this.removedSensors[0] = new NodeArray();
        this.removedSensors[1] = new NodeArray();
        this.addedSensors = new NodeArray[2];
        this.addedSensors[0] = new NodeArray();
        this.addedSensors[1] = new NodeArray();
        this.addedUrls = new NodeArray[2];
        this.addedUrls[0] = new NodeArray();
        this.addedUrls[1] = new NodeArray();
        this.removedViewDependentNodes = new NodeArray[2];
        this.removedViewDependentNodes[0] = new NodeArray();
        this.removedViewDependentNodes[1] = new NodeArray();
        this.addedViewDependentNodes = new NodeArray[2];
        this.addedViewDependentNodes[0] = new NodeArray();
        this.addedViewDependentNodes[1] = new NodeArray();
        this.removedBindables = new NodeArray[2];
        this.removedBindables[0] = new NodeArray();
        this.removedBindables[1] = new NodeArray();
        this.addedBindables = new NodeArray[2];
        this.addedBindables[0] = new NodeArray();
        this.addedBindables[1] = new NodeArray();
        this.addedScenes = new ObjectArray[2];
        this.addedScenes[0] = new ObjectArray();
        this.addedScenes[1] = new ObjectArray();
        this.removedScenes = new ObjectArray[2];
        this.removedScenes[0] = new ObjectArray();
        this.removedScenes[1] = new ObjectArray();
        this.registeredFrameStateListeners = new HashSet();
        this.currentFrameListeners = new FrameStateListener[20];
        this.lastFrameStateIndex = 0;
        this.traverser = new SceneGraphTraverser();
        this.traverser.setObserver((SceneGraphTraversalObserver)this);
        this.idxRScripts = 0;
        this.idxAScripts = 0;
        this.idxRSensors = 0;
        this.idxASensors = 0;
        this.idxAUrls = 0;
        this.idxAViewDependents = 0;
        this.idxRViewDependents = 0;
        this.idxRBindables = 0;
        this.idxABindables = 0;
        this.idxRScenes = 0;
        this.idxAScenes = 0;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void addEndOfThisFrameListener(FrameStateListener frameStateListener) {
        if (this.registeredFrameStateListeners.contains((Object)frameStateListener)) {
            return;
        }
        this.registeredFrameStateListeners.add((Object)frameStateListener);
        if (this.lastFrameStateIndex == this.currentFrameListeners.length) {
            int n = this.lastFrameStateIndex + 5;
            FrameStateListener[] frameStateListenerArray = new FrameStateListener[n];
            System.arraycopy(this.currentFrameListeners, 0, frameStateListenerArray, 0, this.lastFrameStateIndex);
            this.currentFrameListeners = frameStateListenerArray;
        }
        this.currentFrameListeners[this.lastFrameStateIndex++] = frameStateListener;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.lastFrameStateIndex) {
            this.currentFrameListeners[n] = null;
            ++n;
        }
        this.removedScripts[0].clear();
        this.addedScripts[0].clear();
        this.removedSensors[0].clear();
        this.addedSensors[0].clear();
        this.addedUrls[0].clear();
        this.removedViewDependentNodes[0].clear();
        this.addedViewDependentNodes[0].clear();
        this.removedBindables[0].clear();
        this.addedBindables[0].clear();
        this.removedScenes[0].clear();
        this.addedScenes[0].clear();
        this.removedScripts[1].clear();
        this.addedScripts[1].clear();
        this.removedSensors[1].clear();
        this.addedSensors[1].clear();
        this.addedUrls[1].clear();
        this.removedViewDependentNodes[1].clear();
        this.addedViewDependentNodes[1].clear();
        this.removedBindables[1].clear();
        this.addedBindables[1].clear();
        this.removedScenes[1].clear();
        this.addedScenes[1].clear();
        this.idxRScripts = 0;
        this.idxAScripts = 0;
        this.idxRSensors = 0;
        this.idxASensors = 0;
        this.idxAUrls = 0;
        this.idxAViewDependents = 0;
        this.idxRViewDependents = 0;
        this.idxRBindables = 0;
        this.idxABindables = 0;
        this.idxRScenes = 0;
        this.idxAScenes = 0;
        this.registeredFrameStateListeners.clear();
    }

    public void frameFinished() {
        if (this.lastFrameStateIndex == 0) {
            return;
        }
        this.registeredFrameStateListeners.clear();
        int n = 0;
        while (n < this.lastFrameStateIndex) {
            try {
                this.currentFrameListeners[n].allEventsComplete();
                this.currentFrameListeners[n] = null;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(EOF_NOTIF_MSG, exception);
            }
            ++n;
        }
        this.lastFrameStateIndex = 0;
    }

    public synchronized void registerRemovedNode(VRMLNodeType vRMLNodeType) {
        this.addTraversal = false;
        this.traverser.reset();
        this.traverser.traverseGraph(vRMLNodeType);
    }

    public synchronized void registerRemovedNodes(VRMLNodeType[] vRMLNodeTypeArray) {
        this.addTraversal = false;
        int n = 0;
        while (n < vRMLNodeTypeArray.length) {
            if (vRMLNodeTypeArray[n] != null) {
                this.traverser.reset();
                this.traverser.traverseGraph(vRMLNodeTypeArray[n]);
            }
            ++n;
        }
    }

    public synchronized void registerAddedNode(VRMLNodeType vRMLNodeType) {
        this.addTraversal = true;
        this.traverser.reset();
        this.traverser.traverseGraph(vRMLNodeType);
    }

    public synchronized void registerAddedNodes(VRMLNodeType[] vRMLNodeTypeArray) {
        this.addTraversal = true;
        int n = 0;
        while (n < vRMLNodeTypeArray.length) {
            if (vRMLNodeTypeArray[n] != null) {
                this.traverser.reset();
                this.traverser.traverseGraph(vRMLNodeTypeArray[n]);
            }
            ++n;
        }
    }

    public void registerAddedScene(VRMLExecutionSpace vRMLExecutionSpace) {
        this.addedScenes[this.idxAScenes].add((Object)vRMLExecutionSpace);
    }

    public void registerRemovedScene(VRMLExecutionSpace vRMLExecutionSpace) {
        this.removedScenes[this.idxRScenes].add((Object)vRMLExecutionSpace);
    }

    public void clearRemovedNodes() {
        this.removedScripts[this.idxRScripts == 0 ? 1 : 0].clear();
        this.removedSensors[this.idxRSensors == 0 ? 1 : 0].clear();
        this.removedBindables[this.idxRBindables == 0 ? 1 : 0].clear();
        this.removedViewDependentNodes[this.idxRViewDependents == 0 ? 1 : 0].clear();
    }

    public void clearAddedNodes() {
        this.addedScripts[this.idxAScripts == 0 ? 1 : 0].clear();
        this.addedSensors[this.idxASensors == 0 ? 1 : 0].clear();
        this.addedBindables[this.idxABindables == 0 ? 1 : 0].clear();
        this.addedUrls[this.idxAUrls == 0 ? 1 : 0].clear();
        this.addedViewDependentNodes[this.idxAViewDependents == 0 ? 1 : 0].clear();
    }

    public void clearAddedScenes() {
        this.addedScenes[this.idxAScenes == 0 ? 1 : 0].clear();
    }

    public void clearRemovedScenes() {
        this.removedScenes[this.idxAScenes == 0 ? 1 : 0].clear();
    }

    public NodeArray getRemovedScripts() {
        if (this.idxRScripts == 0) {
            this.idxRScripts = 1;
            return this.removedScripts[0];
        }
        this.idxRScripts = 0;
        return this.removedScripts[1];
    }

    public NodeArray getRemovedSensors() {
        if (this.idxRSensors == 0) {
            this.idxRSensors = 1;
            return this.removedSensors[0];
        }
        this.idxRSensors = 0;
        return this.removedSensors[1];
    }

    public NodeArray getRemovedViewDependents() {
        if (this.idxRViewDependents == 0) {
            this.idxRViewDependents = 1;
            return this.removedViewDependentNodes[0];
        }
        this.idxRViewDependents = 0;
        return this.removedViewDependentNodes[1];
    }

    public NodeArray getRemovedBindables() {
        if (this.idxRBindables == 0) {
            this.idxRBindables = 1;
            return this.removedBindables[0];
        }
        this.idxRBindables = 0;
        return this.removedBindables[1];
    }

    public ObjectArray getRemovedScenes() {
        if (this.idxRScenes == 0) {
            this.idxRScenes = 1;
            return this.removedScenes[0];
        }
        this.idxRScenes = 0;
        return this.removedScenes[1];
    }

    public NodeArray getAddedSensors() {
        if (this.idxASensors == 0) {
            this.idxASensors = 1;
            return this.addedSensors[0];
        }
        this.idxASensors = 0;
        return this.addedSensors[1];
    }

    public ObjectArray getAddedScenes() {
        if (this.idxAScenes == 0) {
            this.idxAScenes = 1;
            return this.addedScenes[0];
        }
        this.idxAScenes = 0;
        return this.addedScenes[1];
    }

    public NodeArray getAddedUrlNodes() {
        if (this.idxAUrls == 0) {
            this.idxAUrls = 1;
            return this.addedUrls[0];
        }
        this.idxAUrls = 0;
        return this.addedUrls[1];
    }

    public NodeArray getAddedScripts() {
        if (this.idxAScripts == 0) {
            this.idxAScripts = 1;
            return this.addedScripts[0];
        }
        this.idxAScripts = 0;
        return this.addedScripts[1];
    }

    public NodeArray getAddedViewDependents() {
        if (this.idxAViewDependents == 0) {
            this.idxAViewDependents = 1;
            return this.addedViewDependentNodes[0];
        }
        this.idxAViewDependents = 0;
        return this.addedViewDependentNodes[1];
    }

    public NodeArray getAddedBindables() {
        if (this.idxABindables == 0) {
            this.idxABindables = 1;
            return this.addedBindables[0];
        }
        this.idxABindables = 0;
        return this.addedBindables[1];
    }

    public void groupingNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLGroupingNodeType vRMLGroupingNodeType2, boolean bl) {
        this.processNode((VRMLNodeType)vRMLGroupingNodeType2);
    }

    public void inlineNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInlineNodeType vRMLInlineNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLInlineNodeType);
    }

    public void lightNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLLightNodeType vRMLLightNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLLightNodeType);
    }

    public void bindableNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLBindableNodeType);
    }

    public void shapeNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLShapeNodeType vRMLShapeNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLShapeNodeType);
    }

    public void appearanceNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLAppearanceNodeType vRMLAppearanceNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLAppearanceNodeType);
    }

    public void materialNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLMaterialNodeType vRMLMaterialNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLMaterialNodeType);
    }

    public void textureNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureNodeType vRMLTextureNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLTextureNodeType);
    }

    public void textureTransformNode(VRMLAppearanceNodeType vRMLAppearanceNodeType, VRMLTextureTransformNodeType vRMLTextureTransformNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLTextureTransformNodeType);
    }

    public void geometryNode(VRMLShapeNodeType vRMLShapeNodeType, VRMLGeometryNodeType vRMLGeometryNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLGeometryNodeType);
    }

    public void geometricPropertyNode(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType, VRMLGeometricPropertyNodeType vRMLGeometricPropertyNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLGeometricPropertyNodeType);
    }

    public void soundNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSoundNodeType vRMLSoundNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLSoundNodeType);
    }

    public void audioClipNode(VRMLSoundNodeType vRMLSoundNodeType, VRMLAudioClipNodeType vRMLAudioClipNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLAudioClipNodeType);
    }

    public void sensorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLSensorNodeType vRMLSensorNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLSensorNodeType);
    }

    public void interpolatorNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLInterpolatorNodeType vRMLInterpolatorNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLInterpolatorNodeType);
    }

    public void scriptNode(VRMLGroupingNodeType vRMLGroupingNodeType, VRMLScriptNodeType vRMLScriptNodeType, boolean bl) {
        this.processNode((VRMLNodeType)vRMLScriptNodeType);
    }

    public void protoNode(VRMLNodeType vRMLNodeType, VRMLProtoInstance vRMLProtoInstance, boolean bl) {
    }

    public void customNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        this.processNode(vRMLNodeType2);
    }

    public void miscellaneousNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, boolean bl) {
        this.processNode(vRMLNodeType2);
    }

    private void processNode(VRMLNodeType vRMLNodeType) {
        int[] nArray = vRMLNodeType.getSecondaryType();
        int n = 0;
        while (n < nArray.length) {
            if ((nArray[n] == 44 || nArray[n] == 30) && nArray[n] != 41) {
                if (!this.addTraversal) break;
                this.addedUrls[this.idxAUrls].add(vRMLNodeType);
                break;
            }
            ++n;
        }
        switch (vRMLNodeType.getPrimaryType()) {
            case 13: 
            case 14: 
            case 26: 
            case 36: 
            case 42: {
                if (this.addTraversal) {
                    this.addedSensors[this.idxASensors].add(vRMLNodeType);
                    break;
                }
                this.removedSensors[this.idxRSensors].add(vRMLNodeType);
                break;
            }
            case 41: {
                if (this.addTraversal) {
                    this.addedScripts[this.idxAScripts].add(vRMLNodeType);
                    break;
                }
                this.removedScripts[this.idxRScripts].add(vRMLNodeType);
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 31: 
            case 55: {
                if (this.addTraversal) {
                    this.addedBindables[this.idxABindables].add(vRMLNodeType);
                    break;
                }
                this.removedBindables[this.idxRBindables].add(vRMLNodeType);
            }
        }
    }
}

