/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.awt.event.KeyEvent;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.util.NodeArray;

public class KeyDeviceSensorManager {
    private static final int DEFAULT_LISTENER_SIZE = 10;
    private static final int LISTENER_SIZE_INC = 5;
    private ErrorReporter errorReporter;
    private HashSet keyNodes = new HashSet();
    private NodeArray sensors = new NodeArray();

    public KeyDeviceSensorManager() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void clear() {
        this.keyNodes.clear();
    }

    public void sendEvents(KeyEvent[] keyEventArray, int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.sensors.size();
        int n3 = 0;
        while (n3 < n2) {
            VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType = (VRMLKeyDeviceSensorNodeType)this.sensors.get(n3);
            if (vRMLKeyDeviceSensorNodeType.getEnabled()) {
                int n4;
                int n5 = n4 = vRMLKeyDeviceSensorNodeType.requiresLastEventOnly() ? n - 1 : 0;
                while (n5 < n) {
                    this.sendEvent(vRMLKeyDeviceSensorNodeType, keyEventArray[n5]);
                    ++n5;
                }
            }
            ++n3;
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void addSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (!this.keyNodes.contains((Object)vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.add((Object)vRMLKeyDeviceSensorNodeType);
            this.sensors.add((VRMLNodeType)vRMLKeyDeviceSensorNodeType);
        }
    }

    public void removeSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (this.keyNodes.contains((Object)vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.remove((Object)vRMLKeyDeviceSensorNodeType);
            this.sensors.remove((VRMLNodeType)vRMLKeyDeviceSensorNodeType);
        }
    }

    private void sendEvent(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType, KeyEvent keyEvent) {
        try {
            switch (keyEvent.getID()) {
                case 401: {
                    vRMLKeyDeviceSensorNodeType.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    vRMLKeyDeviceSensorNodeType.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    vRMLKeyDeviceSensorNodeType.keyTyped(keyEvent);
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Error propogating key event", exception);
        }
    }
}

