/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.runtime.EventOutHolder;
import org.web3d.vrml.nodes.runtime.RouteHolder;
import org.web3d.vrml.nodes.runtime.Router;

public class ListsRouter
implements Router {
    private static final int DEFAULT_SIZE = 32;
    private static final int ARRAY_INC = 8;
    private HashSet routeSet = new HashSet();
    private HashSet routesToAdd = new HashSet();
    private HashSet routesToRemove = new HashSet();
    private HashSet processedScripts;
    private int sourceCount = 0;
    private HashMap sourceMap = new HashMap();
    private EventOutHolder[] routeList;
    private ErrorReporter errorReporter;
    private VRMLScriptNodeType[] scriptList;
    private RouteHolder[] routeTmp;

    public ListsRouter() {
        this.processedScripts = new HashSet();
        this.routeList = new EventOutHolder[32];
        this.scriptList = new VRMLScriptNodeType[32];
        this.routeTmp = new RouteHolder[32];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean processRoutes(double d) {
        if (this.sourceCount <= 0) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.sourceCount) {
            if (this.routeList[n].needsProcessing()) {
                ArrayList arrayList = (ArrayList)this.sourceMap.get(this.routeList[n]);
                int n2 = arrayList.size();
                int n3 = 0;
                while (n3 < n2) {
                    RouteHolder routeHolder = (RouteHolder)arrayList.get(n3);
                    routeHolder.sendRoute(d);
                    if (routeHolder.destNode instanceof VRMLScriptNodeType) {
                        this.processedScripts.add((Object)routeHolder.destNode);
                    }
                    ++n3;
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void addRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (this.routeSet.contains((Object)routeHolder) || this.routesToAdd.contains((Object)routeHolder)) {
            return;
        }
        if (this.routesToRemove.contains((Object)routeHolder)) {
            this.routesToRemove.remove((Object)routeHolder);
            return;
        }
        this.routesToAdd.add((Object)routeHolder);
    }

    public void addRoutes(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ROUTE rOUTE = (ROUTE)arrayList.get(n2);
            this.addRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
            ++n2;
        }
    }

    public void removeRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (!this.routeSet.contains((Object)routeHolder) || this.routesToRemove.contains((Object)routeHolder)) {
            return;
        }
        if (this.routesToAdd.contains((Object)routeHolder)) {
            this.routesToAdd.remove((Object)routeHolder);
            return;
        }
        this.routesToRemove.add((Object)routeHolder);
    }

    public void updateRoutes() {
        RouteHolder routeHolder;
        if (this.routesToRemove.size() == 0 && this.routesToAdd.size() == 0) {
            return;
        }
        this.routeSet.removeAll(this.routesToRemove);
        this.routeSet.addAll(this.routesToAdd);
        int n = this.routesToRemove.size();
        if (this.routeTmp.length < n) {
            int n2 = n >= this.routeTmp.length + 8 ? n : this.routeTmp.length + 8;
            this.routeTmp = new RouteHolder[n2];
        }
        this.routesToRemove.toArray((Object[])this.routeTmp);
        EventOutHolder eventOutHolder = new EventOutHolder();
        int n3 = 0;
        while (n3 < n) {
            routeHolder = this.routeTmp[n3];
            this.routeTmp[n3] = null;
            eventOutHolder.srcNode = routeHolder.srcNode;
            eventOutHolder.srcIndex = routeHolder.srcIndex;
            ArrayList arrayList = (ArrayList)this.sourceMap.get(eventOutHolder);
            if (arrayList != null) {
                arrayList.remove(routeHolder);
            }
            ++n3;
        }
        n = this.routesToAdd.size();
        if (this.routeTmp.length < n) {
            int n4 = n >= this.routeTmp.length + 8 ? n : this.routeTmp.length + 8;
            this.routeTmp = new RouteHolder[n4];
        }
        this.routesToAdd.toArray((Object[])this.routeTmp);
        int n5 = 0;
        while (n5 < n) {
            routeHolder = this.routeTmp[n5];
            this.routeTmp[n5] = null;
            eventOutHolder.srcNode = routeHolder.srcNode;
            eventOutHolder.srcIndex = routeHolder.srcIndex;
            ArrayList<RouteHolder> arrayList = (ArrayList<RouteHolder>)this.sourceMap.get(eventOutHolder);
            if (arrayList == null) {
                arrayList = new ArrayList<RouteHolder>();
                EventOutHolder eventOutHolder2 = new EventOutHolder();
                eventOutHolder2.srcNode = routeHolder.srcNode;
                eventOutHolder2.srcIndex = routeHolder.srcIndex;
                this.sourceMap.put(eventOutHolder2, arrayList);
            }
            arrayList.add(routeHolder);
            ++n5;
        }
        this.sourceCount = this.sourceMap.size();
        if (this.sourceCount > this.routeList.length) {
            int n6 = this.routeList.length;
            int n7 = n >= this.routeTmp.length + 8 ? n : this.routeTmp.length + 8;
            EventOutHolder[] eventOutHolderArray = new EventOutHolder[n7];
            System.arraycopy(this.routeList, 0, eventOutHolderArray, 0, n6);
            this.routeList = eventOutHolderArray;
        }
        Set set = this.sourceMap.keySet();
        set.toArray(this.routeList);
        this.routesToAdd.clear();
        this.routesToRemove.clear();
    }

    public void endCascade() {
        int n;
        int n2 = this.processedScripts.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.scriptList.length) {
            n = this.scriptList.length;
            this.scriptList = new VRMLScriptNodeType[this.scriptList.length + 8];
        }
        this.processedScripts.toArray((Object[])this.scriptList);
        n = 0;
        while (n < n2) {
            this.scriptList[n].cascadeComplete();
            ++n;
        }
        this.processedScripts.clear();
    }

    public void clear() {
        this.routeSet.clear();
        this.routesToAdd.clear();
        this.routesToRemove.clear();
        this.processedScripts.clear();
        this.sourceMap.clear();
        int n = 0;
        while (n < this.scriptList.length) {
            this.scriptList[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.sourceCount) {
            this.routeList[n2] = null;
            ++n2;
        }
        this.sourceCount = 0;
    }
}

