/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.runtime.RouteHolder;
import org.web3d.vrml.nodes.runtime.Router;

public class SimpleRouter
implements Router {
    private static final int DEFAULT_SIZE = 32;
    private static final int ARRAY_INC = 8;
    private HashSet routeSet = new HashSet();
    private HashSet routesToAdd = new HashSet();
    private HashSet routesToRemove = new HashSet();
    private HashSet processedScripts;
    private int routeCount = 0;
    private RouteHolder[] routeList = new RouteHolder[32];
    private ErrorReporter errorReporter;
    private VRMLScriptNodeType[] scriptList = new VRMLScriptNodeType[32];

    public SimpleRouter() {
        this.processedScripts = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean processRoutes(double d) {
        if (this.routeCount <= 0) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.routeCount) {
            if (this.routeList[n].needsProcessing()) {
                this.routeList[n].sendRoute(d);
                if (this.routeList[n].destNode instanceof VRMLScriptNodeType) {
                    this.processedScripts.add((Object)this.routeList[n].destNode);
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void addRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (this.routeSet.contains((Object)routeHolder) || this.routesToAdd.contains((Object)routeHolder)) {
            return;
        }
        if (this.routesToRemove.contains((Object)routeHolder)) {
            this.routesToRemove.remove((Object)routeHolder);
            return;
        }
        this.routesToAdd.add((Object)routeHolder);
    }

    public void addRoutes(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ROUTE rOUTE = (ROUTE)arrayList.get(n2);
            this.addRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
            ++n2;
        }
    }

    public void removeRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (!this.routeSet.contains((Object)routeHolder) || this.routesToRemove.contains((Object)routeHolder)) {
            return;
        }
        if (this.routesToAdd.contains((Object)routeHolder)) {
            this.routesToAdd.remove((Object)routeHolder);
            return;
        }
        this.routesToRemove.add((Object)routeHolder);
    }

    public void updateRoutes() {
        if (this.routesToRemove.size() == 0 && this.routesToAdd.size() == 0) {
            return;
        }
        this.routeSet.removeAll(this.routesToRemove);
        this.routeSet.addAll(this.routesToAdd);
        this.routeCount = this.routeSet.size();
        if (this.routeCount > this.routeList.length) {
            int n = this.routeList.length;
            int n2 = this.routeCount >= this.routeList.length + 8 ? this.routeCount : this.routeList.length + 8;
            RouteHolder[] routeHolderArray = new RouteHolder[n2];
            System.arraycopy(this.routeList, 0, routeHolderArray, 0, n);
            this.routeList = routeHolderArray;
        }
        this.routeSet.toArray((Object[])this.routeList);
        this.routesToAdd.clear();
        this.routesToRemove.clear();
    }

    public void endCascade() {
        int n;
        int n2 = this.processedScripts.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.scriptList.length) {
            n = this.scriptList.length;
            this.scriptList = new VRMLScriptNodeType[this.scriptList.length + 8];
        }
        this.processedScripts.toArray((Object[])this.scriptList);
        n = 0;
        while (n < n2) {
            this.scriptList[n].cascadeComplete();
            ++n;
        }
        this.processedScripts.clear();
    }

    public void clear() {
        this.routeSet.clear();
        this.routesToAdd.clear();
        this.routesToRemove.clear();
        this.processedScripts.clear();
        int n = 0;
        while (n < this.scriptList.length) {
            this.scriptList[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.routeCount) {
            this.routeList[n2] = null;
            ++n2;
        }
        this.routeCount = 0;
    }
}

